/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.cxf;

import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.ControlFlowRegistry;
import kieker.monitoring.core.registry.SessionRegistry;
import kieker.monitoring.probe.IMonitoringProbe;
import kieker.monitoring.probe.cxf.SOAPHeaderConstants;
import kieker.monitoring.probe.cxf.SOAPTraceRegistry;
import kieker.monitoring.timer.ITimeSource;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapHeaderInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OperationExecutionSOAPResponseInInterceptor
extends SoapHeaderInterceptor
implements IMonitoringProbe {
    public static final String SIGNATURE = "public void " + OperationExecutionSOAPResponseInInterceptor.class.getName() + ".handleMessage(org.apache.cxf.message.Message)";
    protected static final SessionRegistry SESSION_REGISTRY = SessionRegistry.INSTANCE;
    protected static final ControlFlowRegistry CF_REGISTRY = ControlFlowRegistry.INSTANCE;
    protected static final SOAPTraceRegistry SOAP_REGISTRY = SOAPTraceRegistry.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationExecutionSOAPResponseInInterceptor.class);
    protected final IMonitoringController monitoringController;
    protected final ITimeSource timeSource;
    protected final String vmName;

    public OperationExecutionSOAPResponseInInterceptor() {
        this(MonitoringController.getInstance());
    }

    public OperationExecutionSOAPResponseInInterceptor(IMonitoringController monitoringCtrl) {
        this.monitoringController = monitoringCtrl;
        this.timeSource = this.monitoringController.getTimeSource();
        this.vmName = this.monitoringController.getHostname();
    }

    public void handleMessage(Message msg) throws Fault {
        if (!this.monitoringController.isMonitoringEnabled()) {
            return;
        }
        if (!this.monitoringController.isProbeActivated(SIGNATURE)) {
            return;
        }
        if (msg instanceof SoapMessage) {
            long traceId;
            boolean isEntryCall = SOAP_REGISTRY.recallThreadLocalOutRequestIsEntryCall();
            SoapMessage soapMsg = (SoapMessage)msg;
            Header hdr = soapMsg.getHeader(SOAPHeaderConstants.EOI_IDENTIFIER_QNAME);
            String eoiStr = this.getStringContentFromHeader(hdr);
            if (eoiStr == null) {
                LOGGER.info("Found no Kieker eoi in response header. Will unset all threadLocal variables");
                this.unsetKiekerThreadLocalData();
                return;
            }
            int eoi = 0;
            try {
                eoi = Integer.parseInt(eoiStr);
            }
            catch (NumberFormatException exc) {
                LOGGER.warn("Invalid EOI", exc);
                this.unsetKiekerThreadLocalData();
                return;
            }
            hdr = soapMsg.getHeader(SOAPHeaderConstants.TRACE_IDENTIFIER_QNAME);
            String traceIdStr = this.getStringContentFromHeader(hdr);
            if (traceIdStr == null) {
                LOGGER.info("Found no Kieker traceId in response header. Will unset all threadLocal variables");
                this.unsetKiekerThreadLocalData();
                return;
            }
            try {
                traceId = Long.parseLong(traceIdStr);
            }
            catch (NumberFormatException exc) {
                LOGGER.warn("Invalid trace id", exc);
                this.unsetKiekerThreadLocalData();
                return;
            }
            long myTraceId = CF_REGISTRY.recallThreadLocalTraceId();
            String mySessionId = SESSION_REGISTRY.recallThreadLocalSessionId();
            int myEoi = CF_REGISTRY.recallThreadLocalEOI();
            int myEss = CF_REGISTRY.recallThreadLocalESS();
            long myTin = SOAP_REGISTRY.recallThreadLocalOutRequestTin();
            long myTout = this.timeSource.getTime();
            if (myTraceId != traceId) {
                LOGGER.warn("Inconsistency between traceId before and after SOAP request:\n{}(before) != {}(after)", (Object)myTraceId, (Object)traceId);
            }
            OperationExecutionRecord rec = new OperationExecutionRecord(SIGNATURE, mySessionId, myTraceId, myTin, myTout, this.vmName, myEoi, myEss);
            this.monitoringController.newMonitoringRecord(rec);
            CF_REGISTRY.storeThreadLocalEOI(eoi);
            if (isEntryCall) {
                this.unsetKiekerThreadLocalData();
            }
        }
    }

    private final String getStringContentFromHeader(Header hdr) {
        if (hdr == null) {
            return null;
        }
        if (hdr.getObject() instanceof Element) {
            Element e = (Element)hdr.getObject();
            return DOMUtils.getContent((Node)e);
        }
        return null;
    }

    private final void unsetKiekerThreadLocalData() {
        CF_REGISTRY.unsetThreadLocalTraceId();
        SESSION_REGISTRY.unsetThreadLocalSessionId();
        CF_REGISTRY.unsetThreadLocalEOI();
        CF_REGISTRY.unsetThreadLocalESS();
        SOAP_REGISTRY.unsetThreadLocalOutRequestIsEntryCall();
        SOAP_REGISTRY.unsetThreadLocalOutRequestTin();
    }
}

