/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.cxf;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SOAPTraceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOAPTraceRegistry.class);
    private static final SOAPTraceRegistry INSTANCE = new SOAPTraceRegistry();
    private final ThreadLocal<Long> threadLocalInRequestTin = new ThreadLocal();
    private final ThreadLocal<Long> threadLocalOutRequestTin = new ThreadLocal();
    private final ThreadLocal<Boolean> threadLocalInRequestIsEntryCall = new ThreadLocal();
    private final ThreadLocal<Boolean> threadLocalOutRequestIsEntryCall = new ThreadLocal();
    private final ThreadLocal<Integer> threadLocalInRequestEoi = new ThreadLocal();
    private final ThreadLocal<Integer> threadLocalInRequestEss = new ThreadLocal();

    private SOAPTraceRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SOAPTraceRegistry getInstance() {
        Class<SOAPTraceRegistry> clazz = SOAPTraceRegistry.class;
        synchronized (SOAPTraceRegistry.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public final void storeThreadLocalInRequestTin(long tin) {
        this.threadLocalInRequestTin.set(tin);
    }

    public final long recallThreadLocalInRequestTin() {
        Long curTin = this.threadLocalInRequestTin.get();
        if (curTin == null) {
            LOGGER.error("tin has not been registered before");
            return -1L;
        }
        return curTin;
    }

    public final void unsetThreadLocalInRequestTin() {
        this.threadLocalInRequestTin.remove();
    }

    public final void storeThreadLocalOutRequestTin(long tin) {
        this.threadLocalOutRequestTin.set(tin);
    }

    public final long recallThreadLocalOutRequestTin() {
        Long curTin = this.threadLocalOutRequestTin.get();
        if (curTin == null) {
            LOGGER.error("tin has not been registered before");
            return -1L;
        }
        return curTin;
    }

    public final void unsetThreadLocalOutRequestTin() {
        this.threadLocalOutRequestTin.remove();
    }

    public final void storeThreadLocalInRequestIsEntryCall(boolean isEntry) {
        this.threadLocalInRequestIsEntryCall.set(isEntry);
    }

    public final boolean recallThreadLocalInRequestIsEntryCall() {
        Boolean curIsEntryCall = this.threadLocalInRequestIsEntryCall.get();
        if (curIsEntryCall == null) {
            LOGGER.error("isEntryCall has not been registered before");
            return true;
        }
        return curIsEntryCall;
    }

    public final void unsetThreadLocalInRequestIsEntryCall() {
        this.threadLocalInRequestIsEntryCall.remove();
    }

    public final void storeThreadLocalOutRequestIsEntryCall(boolean isEntry) {
        this.threadLocalOutRequestIsEntryCall.set(isEntry);
    }

    public final boolean recallThreadLocalOutRequestIsEntryCall() {
        Boolean curIsEntryCall = this.threadLocalOutRequestIsEntryCall.get();
        if (curIsEntryCall == null) {
            LOGGER.error("isEntryCall has not been registered before");
            return true;
        }
        return curIsEntryCall;
    }

    public final void unsetThreadLocalOutRequestIsEntryCall() {
        this.threadLocalOutRequestIsEntryCall.remove();
    }

    public final void storeThreadLocalInRequestEOI(int eoi) {
        this.threadLocalInRequestEoi.set(eoi);
    }

    public final int recallThreadLocalInRequestEOI() {
        Integer curEoi = this.threadLocalInRequestEoi.get();
        if (curEoi == null) {
            LOGGER.error("eoi has not been registered before");
            return -1;
        }
        return curEoi;
    }

    public final void unsetThreadLocalInRequestEOI() {
        this.threadLocalInRequestEoi.remove();
    }

    public final void storeThreadLocalInRequestESS(int ess) {
        this.threadLocalInRequestEss.set(ess);
    }

    public final int recallThreadLocalInRequestESS() {
        Integer curEss = this.threadLocalInRequestEss.get();
        if (curEss == null) {
            LOGGER.error("ess has not been registered before");
            return -1;
        }
        return curEss;
    }

    public final void unsetThreadLocalInRequestESS() {
        this.threadLocalInRequestEss.remove();
    }
}

