/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.servlet;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import kieker.monitoring.core.controller.ISamplingController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.sampler.ISampler;
import kieker.monitoring.core.sampler.ScheduledSamplerJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegularSamplingServletContextListener
implements ServletContextListener {
    public static final long DEFAULT_SENSOR_INTERVAL_SECONDS = 15L;
    public static final long DEFAULT_SENSOR_INITIAL_DELAY_SECONDS = 0L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRegularSamplingServletContextListener.class);
    private final String contextParameterNameSamplingIntervalSeconds = this.getContextParameterNameSamplingIntervalSeconds();
    private final String contextParameterNameSamplingDelaySeconds = this.getContextParameterNameSamplingDelaySeconds();
    private final ISamplingController samplingController = MonitoringController.getInstance();
    private final Collection<ScheduledSamplerJob> startedSamplerJobs = new CopyOnWriteArrayList<ScheduledSamplerJob>();
    private volatile long sensorIntervalSeconds = 15L;
    private volatile long initialDelaySeconds = 0L;

    public void contextDestroyed(ServletContextEvent event) {
        for (ScheduledSamplerJob s : this.startedSamplerJobs) {
            this.samplingController.removeScheduledSampler(s);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        this.initParameters(event.getServletContext());
        this.initSensors();
    }

    private void initParameters(ServletContext c) {
        if (c == null) {
            LOGGER.warn("ServletContext == null");
            return;
        }
        this.initialDelaySeconds = this.readLongInitParameter(c, this.contextParameterNameSamplingDelaySeconds, 0L);
        this.sensorIntervalSeconds = this.readLongInitParameter(c, this.contextParameterNameSamplingIntervalSeconds, 15L);
        if (this.sensorIntervalSeconds == 0L) {
            LOGGER.warn("values for the init-param '{}' must be >0; found: {}. Using default value: {}", this.contextParameterNameSamplingIntervalSeconds, this.sensorIntervalSeconds, 15L);
            this.sensorIntervalSeconds = 15L;
        }
    }

    private long readLongInitParameter(ServletContext c, String paramName, long defaultValue) {
        long val = -1L;
        String valStr = c.getInitParameter(paramName);
        if (valStr != null) {
            try {
                val = Long.parseLong(valStr);
            }
            catch (NumberFormatException exc) {
                val = -1L;
            }
        }
        if (val < 0L) {
            LOGGER.warn("Invalid or missing value for context-param '{}': {}. Using default value: {}", paramName, valStr, defaultValue);
            val = defaultValue;
        }
        return val;
    }

    private void initSensors() {
        ISampler[] samplers;
        for (ISampler sampler : samplers = this.createSamplers()) {
            ScheduledSamplerJob job = this.samplingController.schedulePeriodicSampler(sampler, this.initialDelaySeconds, this.sensorIntervalSeconds, TimeUnit.SECONDS);
            this.startedSamplerJobs.add(job);
        }
    }

    protected abstract String getContextParameterNameSamplingIntervalSeconds();

    protected abstract String getContextParameterNameSamplingDelaySeconds();

    protected abstract ISampler[] createSamplers();
}

