/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.queue.behavior;

import java.util.concurrent.BlockingQueue;
import kieker.monitoring.queue.behavior.InsertBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminateOnFailedInsertBehavior<E>
implements InsertBehavior<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminateOnFailedInsertBehavior.class);
    private final BlockingQueue<E> queue;

    public TerminateOnFailedInsertBehavior(BlockingQueue<E> queue) {
        this.queue = queue;
    }

    @Override
    public boolean insert(E element) {
        boolean offered = this.queue.offer(element);
        if (!offered) {
            LOGGER.error("Failed to add new monitoring record to queue. Queue is full. Either increase 'QueueSize' or change 'QueueFullBehavior' for the configured writer.");
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.getClass());
        return builder.toString();
    }
}

