/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.queue.putstrategy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import kieker.monitoring.queue.putstrategy.PutStrategy;

public class SPBlockingPutStrategy
implements PutStrategy {
    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public volatile int storeFence = 0;
    private final AtomicReference<Thread> t = new AtomicReference<Object>(null);

    @Override
    public void signal() {
        this.storeFence = 1;
        LockSupport.unpark(this.t.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> void backoffOffer(Queue<E> q, E e) throws InterruptedException {
        boolean offered = q.offer(e);
        if (offered) {
            return;
        }
        this.t.set(Thread.currentThread());
        try {
            while (!q.offer(e)) {
                LockSupport.park();
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException("Interrupted while waiting for the queue to become non-full.");
            }
        }
        finally {
            this.t.lazySet(null);
        }
    }
}

