/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.queue.takestrategy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import kieker.monitoring.queue.takestrategy.TakeStrategy;

public final class SCBlockingTakeStrategy
implements TakeStrategy {
    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public volatile int storeFence = 0;
    private final AtomicReference<Thread> t = new AtomicReference<Object>(null);

    @Override
    public void signal() {
        this.storeFence = 1;
        LockSupport.unpark(this.t.get());
    }

    @Override
    public <E> E waitPoll(Queue<E> q) throws InterruptedException {
        E e = q.poll();
        if (e != null) {
            return e;
        }
        this.t.set(Thread.currentThread());
        try {
            e = q.poll();
            while (e == null) {
                LockSupport.park();
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Interrupted while waiting for the queue to become non-empty.");
                }
                e = q.poll();
            }
        }
        finally {
            this.t.lazySet(null);
        }
        return e;
    }
}

