/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.sigar;

import kieker.monitoring.sampler.sigar.ISigarSamplerFactory;
import kieker.monitoring.sampler.sigar.samplers.CPUsCombinedPercSampler;
import kieker.monitoring.sampler.sigar.samplers.CPUsDetailedPercSampler;
import kieker.monitoring.sampler.sigar.samplers.DiskUsageSampler;
import kieker.monitoring.sampler.sigar.samplers.LoadAverageSampler;
import kieker.monitoring.sampler.sigar.samplers.MemSwapUsageSampler;
import kieker.monitoring.sampler.sigar.samplers.NetworkUtilizationSampler;
import org.hyperic.sigar.Humidor;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SigarSamplerFactory implements ISigarSamplerFactory
{
    INSTANCE;

    private final SigarProxy sigar;

    private SigarSamplerFactory() {
        Logger logger = LoggerFactory.getLogger(SigarSamplerFactory.class);
        Sigar mySigar = new Sigar();
        if (mySigar.getNativeLibrary() == null) {
            logger.error("No Sigar native lib in java.library.path. See Sigar log for details (maybe only visible on Debug log-level).");
        }
        Humidor humidor = new Humidor(mySigar);
        this.sigar = humidor.getSigar();
    }

    public final SigarProxy getSigar() {
        return this.sigar;
    }

    @Override
    public CPUsCombinedPercSampler createSensorCPUsCombinedPerc() {
        return new CPUsCombinedPercSampler(this.sigar);
    }

    @Override
    public CPUsDetailedPercSampler createSensorCPUsDetailedPerc() {
        return new CPUsDetailedPercSampler(this.sigar);
    }

    @Override
    public MemSwapUsageSampler createSensorMemSwapUsage() {
        return new MemSwapUsageSampler(this.sigar);
    }

    @Override
    public LoadAverageSampler createSensorLoadAverage() {
        return new LoadAverageSampler(this.sigar);
    }

    @Override
    public NetworkUtilizationSampler createSensorNetworkUtilization() {
        return new NetworkUtilizationSampler(this.sigar);
    }

    @Override
    public DiskUsageSampler createSensorDiskUsage() {
        return new DiskUsageSampler(this.sigar);
    }
}

