/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.sigar.samplers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kieker.common.record.system.DiskUsageRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.signaturePattern.SignatureFactory;
import kieker.monitoring.sampler.sigar.samplers.AbstractSigarSampler;
import kieker.monitoring.timer.ITimeSource;
import org.hyperic.sigar.DiskUsage;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

public final class DiskUsageSampler
extends AbstractSigarSampler {
    private final ConcurrentHashMap<String, DiskUsageStatistic> diskUsageStatisticMap = new ConcurrentHashMap();

    public DiskUsageSampler(SigarProxy sigar) {
        super(sigar);
    }

    @Override
    public void sample(IMonitoringController monitoringController) throws SigarException {
        if (!monitoringController.isMonitoringEnabled()) {
            return;
        }
        if (!monitoringController.isProbeActivated(SignatureFactory.createDiskUsageSignature())) {
            return;
        }
        for (FileSystem fileSystem : this.sigar.getFileSystemList()) {
            if (fileSystem.getType() != 2) continue;
            String deviceName = fileSystem.getDevName();
            ITimeSource timesource = monitoringController.getTimeSource();
            TimeUnit timeUnit = timesource.getTimeUnit();
            DiskUsageStatistic currentDiskUsageStatistic = this.getCurrentDiskUsageStatistic(timesource, deviceName);
            if (!this.diskUsageStatisticMap.containsKey(deviceName)) {
                this.diskUsageStatisticMap.putIfAbsent(deviceName, currentDiskUsageStatistic);
                continue;
            }
            DiskUsageStatistic lastObservedDiskUsageStatistic = this.diskUsageStatisticMap.get(deviceName);
            long timeDifference = currentDiskUsageStatistic.getTimestamp() - lastObservedDiskUsageStatistic.getTimestamp();
            if (timeDifference <= 0L) {
                throw new IllegalStateException("Timestamp of new observation should be strictly larger than the previous one.");
            }
            double currentQueue = currentDiskUsageStatistic.getQueue();
            long readBytesDifference = currentDiskUsageStatistic.getReadBytes() - lastObservedDiskUsageStatistic.getReadBytes();
            long readsDifference = currentDiskUsageStatistic.getReads() - lastObservedDiskUsageStatistic.getReads();
            double currentServiceTime = currentDiskUsageStatistic.getServiceTime();
            long writeBytesDifference = currentDiskUsageStatistic.getWriteBytes() - lastObservedDiskUsageStatistic.getWriteBytes();
            long writesDifference = currentDiskUsageStatistic.getWrites() - lastObservedDiskUsageStatistic.getWrites();
            double readBytesPerSecond = (double)readBytesDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double readsPerSecond = (double)readsDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double writeBytesPerSecond = (double)writeBytesDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            double writesPerSecond = (double)writesDifference / (double)TimeUnit.SECONDS.convert(timeDifference, timeUnit);
            DiskUsageRecord diskUsageRecord = new DiskUsageRecord(currentDiskUsageStatistic.getTimestamp(), monitoringController.getHostname(), deviceName, currentQueue, readBytesPerSecond, readsPerSecond, currentServiceTime, writeBytesPerSecond, writesPerSecond);
            monitoringController.newMonitoringRecord(diskUsageRecord);
            this.diskUsageStatisticMap.put(deviceName, currentDiskUsageStatistic);
        }
    }

    private DiskUsageStatistic getCurrentDiskUsageStatistic(ITimeSource timesource, String deviceName) throws SigarException {
        DiskUsage diskUsage = this.sigar.getDiskUsage(deviceName);
        long currentTimestamp = timesource.getTime();
        double queue = diskUsage.getQueue();
        long readBytes = diskUsage.getReadBytes();
        long reads = diskUsage.getReads();
        double serviceTime = diskUsage.getServiceTime();
        long writeBytes = diskUsage.getWriteBytes();
        long writes = diskUsage.getWrites();
        return new DiskUsageStatistic(currentTimestamp, queue, readBytes, reads, serviceTime, writeBytes, writes);
    }

    static class DiskUsageStatistic {
        private final long timestamp;
        private final double queue;
        private final long readBytes;
        private final long reads;
        private final double serviceTime;
        private final long writeBytes;
        private final long writes;

        public DiskUsageStatistic(long timestamp, double queue, long readBytes, long reads, double serviceTime, long writeBytes, long writes) {
            this.timestamp = timestamp;
            this.queue = queue;
            this.readBytes = readBytes;
            this.reads = reads;
            this.serviceTime = serviceTime;
            this.writeBytes = writeBytes;
            this.writes = writes;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public double getQueue() {
            return this.queue;
        }

        public long getReadBytes() {
            return this.readBytes;
        }

        public long getReads() {
            return this.reads;
        }

        public double getServiceTime() {
            return this.serviceTime;
        }

        public long getWriteBytes() {
            return this.writeBytes;
        }

        public long getWrites() {
            return this.writes;
        }
    }
}

