/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.sigar.samplers;

import kieker.common.record.system.LoadAverageRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.signaturePattern.SignatureFactory;
import kieker.monitoring.sampler.sigar.samplers.AbstractSigarSampler;
import kieker.monitoring.timer.ITimeSource;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

public final class LoadAverageSampler
extends AbstractSigarSampler {
    public LoadAverageSampler(SigarProxy sigar) {
        super(sigar);
    }

    @Override
    public void sample(IMonitoringController monitoringController) throws SigarException {
        if (!monitoringController.isMonitoringEnabled()) {
            return;
        }
        if (!monitoringController.isProbeActivated(SignatureFactory.createLoadAverageSignature())) {
            return;
        }
        double[] loadAverage = this.sigar.getLoadAverage();
        if (loadAverage.length != 3) {
            return;
        }
        ITimeSource timesource = monitoringController.getTimeSource();
        LoadAverageRecord r = new LoadAverageRecord(timesource.getTime(), monitoringController.getHostname(), loadAverage[0], loadAverage[1], loadAverage[2]);
        monitoringController.newMonitoringRecord(r);
    }
}

