/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

class MappingFileWriter {
    private final PrintWriter printWriter;

    public MappingFileWriter(Path folder, String charsetName) {
        Path newMappingFile = folder.resolve("kieker.map");
        Charset charset = Charset.forName(charsetName);
        try {
            BufferedWriter w = Files.newBufferedWriter(newMappingFile, charset, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            this.printWriter = new PrintWriter(w);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error on creating Kieker's mapping file.", e);
        }
    }

    public PrintWriter getFileWriter() {
        return this.printWriter;
    }

    public void close() {
        this.printWriter.close();
    }
}

