/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kieker.common.configuration.Configuration;
import kieker.common.util.classpath.InstantiationFactory;
import kieker.monitoring.core.controller.ReceiveUnfilteredConfiguration;
import kieker.monitoring.writer.compression.ICompressionFilter;
import kieker.monitoring.writer.compression.NoneCompressionFilter;
import kieker.monitoring.writer.filesystem.IMapFileHandler;

@ReceiveUnfilteredConfiguration
public class TextMapFileHandler
implements IMapFileHandler {
    public static final String PREFIX = TextMapFileHandler.class.getName() + ".";
    public static final String CONFIG_COMPRESSION_FILTER = PREFIX + "compression";
    public static final String CONFIG_FLUSH_MAPFILE = PREFIX + "flush";
    public static final String CONFIG_BUFFERSIZE = PREFIX + "bufferSize";
    private final ICompressionFilter compressionFilter;
    private PrintWriter printWriter;
    private final boolean flushMapFile;

    public TextMapFileHandler(Configuration configuration) {
        String compressionFilterClassName = configuration.getStringProperty(CONFIG_COMPRESSION_FILTER, NoneCompressionFilter.class.getName());
        this.compressionFilter = InstantiationFactory.getInstance(configuration).createAndInitialize(ICompressionFilter.class, compressionFilterClassName, configuration);
        this.flushMapFile = configuration.getBooleanProperty(CONFIG_FLUSH_MAPFILE, true);
    }

    @Override
    public void create(Path location, Charset charset) {
        try {
            BufferedWriter w = Files.newBufferedWriter(location, charset, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            this.printWriter = new PrintWriter(w);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error on creating Kieker's mapping file.", e);
        }
    }

    @Override
    public void close() {
        this.printWriter.close();
    }

    @Override
    public void add(int id, String eventClassName) {
        this.printWriter.print('$');
        this.printWriter.print(id);
        this.printWriter.print('=');
        this.printWriter.print(eventClassName);
        this.printWriter.println();
        if (this.flushMapFile) {
            this.printWriter.flush();
        }
    }
}

