/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.serializer;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.writer.serializer.AbstractMonitoringRecordSerializer;

public class StringSerializer
extends AbstractMonitoringRecordSerializer {
    private static final Charset CHARSET = Charset.forName("UTF-8");

    public StringSerializer(Configuration configuration) {
        super(configuration);
    }

    private static byte[] stringBuilderToBytes(StringBuilder builder) {
        return builder.toString().getBytes(CHARSET);
    }

    @Override
    public int serializeRecord(IMonitoringRecord record, ByteBuffer buffer) {
        byte[] rawData = this.serializeRecord(record);
        buffer.put(rawData);
        return rawData.length;
    }

    private byte[] serializeRecord(IMonitoringRecord record) {
        return StringSerializer.stringBuilderToBytes(this.appendSingleRecord(record, new StringBuilder()));
    }

    private StringBuilder appendSingleRecord(IMonitoringRecord record, StringBuilder builder) {
        builder.append(record.getClass().getName());
        builder.append(';');
        builder.append(record.getLoggingTimestamp());
        builder.append(';');
        builder.append(record.toString());
        builder.append('\n');
        return builder;
    }

    @Override
    public int serializeRecords(Collection<IMonitoringRecord> records, ByteBuffer buffer) {
        byte[] rawData = this.serializeRecords(records);
        buffer.put(rawData);
        return rawData.length;
    }

    private byte[] serializeRecords(Collection<IMonitoringRecord> records) {
        StringBuilder builder = new StringBuilder();
        for (IMonitoringRecord record : records) {
            this.appendSingleRecord(record, builder);
        }
        return StringSerializer.stringBuilderToBytes(builder);
    }

    @Override
    public void onInitialization() {
    }

    @Override
    public void onTermination() {
    }
}

