/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools;

import java.io.File;
import java.io.IOException;
import kieker.analysis.AnalysisController;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.tools.AbstractCommandLineTool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KaxRun
extends AbstractCommandLineTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(KaxRun.class);
    private String kaxFilename;

    private KaxRun() {
        super(true);
    }

    public static void main(String[] args) {
        new KaxRun().start(args);
    }

    @Override
    protected void addAdditionalOptions(Options options) {
        Option inputOption = new Option("i", "input", true, "the analysis project file (.kax) loaded");
        inputOption.setArgName("filename");
        options.addOption(inputOption);
    }

    @Override
    protected boolean readPropertiesFromCommandLine(CommandLine commandLine) {
        this.kaxFilename = commandLine.getOptionValue('i');
        return this.assertInputFileExists();
    }

    private boolean assertInputFileExists() {
        if (this.kaxFilename == null) {
            LOGGER.error("No input file configured");
            return false;
        }
        return true;
    }

    @Override
    protected boolean performTask() {
        boolean success = false;
        try {
            new AnalysisController(new File(this.kaxFilename)).run();
            success = true;
        }
        catch (IOException ex) {
            LOGGER.error("The given file could not be loaded", ex);
        }
        catch (AnalysisConfigurationException ex) {
            LOGGER.error("The given configuration file is invalid", ex);
        }
        catch (Exception ex) {
            LOGGER.error("Error", ex);
        }
        return success;
    }
}

