/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import kieker.analysis.AnalysisController;
import kieker.analysis.model.analysisMetaModel.MIAnalysisComponent;
import kieker.analysis.model.analysisMetaModel.MIFilter;
import kieker.analysis.model.analysisMetaModel.MIInputPort;
import kieker.analysis.model.analysisMetaModel.MIOutputPort;
import kieker.analysis.model.analysisMetaModel.MIPlugin;
import kieker.analysis.model.analysisMetaModel.MIPort;
import kieker.analysis.model.analysisMetaModel.MIProject;
import kieker.analysis.model.analysisMetaModel.MIReader;
import kieker.analysis.model.analysisMetaModel.MIRepository;
import kieker.analysis.model.analysisMetaModel.MIRepositoryConnector;
import kieker.tools.AbstractCommandLineTool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class KaxViz
extends AbstractCommandLineTool {
    static final Logger LOGGER = LoggerFactory.getLogger(KaxViz.class);
    private String kaxFilename;
    private String svgFilename;

    private KaxViz() {
        super(true);
    }

    public static final void main(String[] args) {
        new KaxViz().start(args);
    }

    @Override
    protected void addAdditionalOptions(Options options) {
        Option inputOption = new Option("i", "input", true, "the analysis project file (.kax) loaded");
        Option outputoption = new Option("svg", true, "name of svg saved on close");
        inputOption.setArgName("filename");
        outputoption.setArgName("filename");
        options.addOption(inputOption);
        options.addOption(outputoption);
    }

    @Override
    protected boolean readPropertiesFromCommandLine(CommandLine commandLine) {
        this.kaxFilename = commandLine.getOptionValue('i');
        this.svgFilename = commandLine.getOptionValue("svg");
        return this.assertInputFileExists();
    }

    private boolean assertInputFileExists() {
        if (this.kaxFilename == null) {
            LOGGER.error("No input file configured");
            return false;
        }
        return true;
    }

    @Override
    protected boolean performTask() {
        try {
            KaxVizFrame frame = new KaxVizFrame(this.kaxFilename, AnalysisController.loadFromFile(new File(this.kaxFilename)), this.svgFilename);
            frame.setDefaultCloseOperation(3);
            frame.setExtendedState(6);
            frame.setSize(800, 600);
            frame.setVisible(true);
        }
        catch (IOException ex) {
            LOGGER.error("The given file could not be loaded", ex);
            return false;
        }
        catch (Exception ex) {
            LOGGER.error("Error", ex);
            return false;
        }
        return true;
    }

    private static class KaxVizFrame
    extends JFrame {
        private static final long serialVersionUID = 1969467089938687452L;
        private static final int FILTER_HEIGHT = 80;
        private static final int FILTER_WIDTH = 200;
        private static final int FILTER_SPACE = 30;
        private static final String STYLE_READER_COLOR = mxConstants.STYLE_FILLCOLOR + "=#A3C592;";
        private static final String STYLE_FILTER_COLOR = mxConstants.STYLE_FILLCOLOR + "=#C3D9FF;";
        private static final String STYLE_REPOSITORY_COLOR = mxConstants.STYLE_FILLCOLOR + "=#EAE385;";
        private static final String STYLE_READER = STYLE_READER_COLOR + mxConstants.STYLE_STROKECOLOR + "=#000000;" + mxConstants.STYLE_FONTCOLOR + "=#000000;";
        private static final String STYLE_FILTER = STYLE_FILTER_COLOR + mxConstants.STYLE_STROKECOLOR + "=#000000;" + mxConstants.STYLE_FONTCOLOR + "=#000000;";
        private static final String STYLE_REPOSITORY = STYLE_REPOSITORY_COLOR + mxConstants.STYLE_ROUNDED + "=1;" + mxConstants.STYLE_STROKECOLOR + "=#000000;" + mxConstants.STYLE_FONTCOLOR + "=#000000;";
        private static final String STYLE_PORT = mxConstants.STYLE_NOLABEL + "=1;" + mxConstants.STYLE_STROKECOLOR + "=#000000;" + mxConstants.STYLE_FONTCOLOR + "=#000000;" + mxConstants.STYLE_FONTSTYLE + "=" + 2 + ";";
        private static final String STYLE_CONNECTION = mxConstants.STYLE_EDGE + "=orthogonalEdgeStyle;";
        private static final String STYLE_CONNECTION_REPOSITORY = mxConstants.STYLE_EDGE + "=orthogonalEdgeStyle;" + mxConstants.STYLE_DASHED + "=1;" + mxConstants.STYLE_FONTCOLOR + "=#000000;" + mxConstants.STYLE_FONTSTYLE + "=" + 2 + ";";
        final transient mxGraph graph;
        private final transient MIProject mProject;

        public KaxVizFrame(String filename, MIProject mProject, final String outFilename) {
            super((mProject.getName() != null ? mProject.getName() + " " : "") + "(" + filename + (null != outFilename ? " -> " + outFilename : "") + ")");
            this.mProject = mProject;
            if (null != outFilename) {
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        Document doc = mxCellRenderer.createSvgDocument((mxGraph)graph, null, (double)1.0, (Color)Color.WHITE, (mxRectangle)graph.getGraphBounds());
                        try {
                            mxUtils.writeFile((String)mxXmlUtils.getXml((Node)doc), (String)outFilename);
                        }
                        catch (IOException ex) {
                            LOGGER.error("Failed to save Visualization of kax-File.", ex);
                        }
                    }
                });
            }
            this.graph = new mxGraph();
            this.graph.setCellsLocked(false);
            this.graph.setCellsEditable(false);
            this.graph.setCellsResizable(false);
            this.graph.setCellsDeletable(false);
            this.graph.setCellsCloneable(false);
            this.graph.setCellsDisconnectable(false);
            this.graph.setDropEnabled(false);
            this.graph.setSplitEnabled(false);
            this.graph.setKeepEdgesInForeground(true);
            this.graph.setCollapseToPreferredSize(false);
            this.graph.setAllowNegativeCoordinates(false);
            this.graph.setExtendParents(false);
            this.graph.setExtendParentsOnAdd(false);
            this.graph.setResetEdgesOnConnect(false);
            this.graph.setAllowDanglingEdges(false);
            this.graph.setDisconnectOnMove(false);
            mxGraphComponent graphComponent = new mxGraphComponent(this.graph);
            graphComponent.setConnectable(false);
            graphComponent.setGridVisible(true);
            graphComponent.setFoldingEnabled(false);
            new mxRubberband(graphComponent);
            this.getContentPane().add((Component)graphComponent);
            this.displayGraph();
            this.graph.addListener("cellsMoved", new mxEventSource.mxIEventListener(){

                public void invoke(Object sender, mxEventObject evt) {
                    graph.repaint();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void displayGraph() {
            HashMap<MIPlugin, mxCell> mapPlugin2Graph = new HashMap<MIPlugin, mxCell>();
            HashMap<MIFilter, Map<String, mxCell>> mapPluginInputPorts2Graph = new HashMap<MIFilter, Map<String, mxCell>>();
            HashMap<MIPlugin, Map<String, mxCell>> mapPluginOutputPorts2Graph = new HashMap<MIPlugin, Map<String, mxCell>>();
            HashMap<MIRepository, mxCell> mapRepository2Graph = new HashMap<MIRepository, mxCell>();
            this.graph.getModel().beginUpdate();
            try {
                int x = 0;
                for (MIPlugin plugin : this.mProject.getPlugins()) {
                    mxCell vertex;
                    if (plugin instanceof MIReader) {
                        MIReader reader = (MIReader)plugin;
                        vertex = this.createReader(reader, x++);
                        mapPlugin2Graph.put(reader, vertex);
                        mapPluginOutputPorts2Graph.put(reader, this.createOutputPorts(reader, vertex, true));
                        continue;
                    }
                    if (!(plugin instanceof MIFilter)) continue;
                    MIFilter filter = (MIFilter)plugin;
                    vertex = this.createFilter(filter, x++);
                    mapPlugin2Graph.put(filter, vertex);
                    mapPluginInputPorts2Graph.put(filter, this.createInputPorts(filter, vertex));
                    mapPluginOutputPorts2Graph.put(filter, this.createOutputPorts(filter, vertex, false));
                }
                for (MIRepository repo : this.mProject.getRepositories()) {
                    mxCell cell = this.createRepository(repo, x++);
                    mapRepository2Graph.put(repo, cell);
                }
                for (MIPlugin outputPlugin : this.mProject.getPlugins()) {
                    Map mapOutputPorts2Graph = (Map)mapPluginOutputPorts2Graph.get(outputPlugin);
                    for (MIOutputPort outputPort : outputPlugin.getOutputPorts()) {
                        for (MIInputPort inputPort : outputPort.getSubscribers()) {
                            mxCell outputPluginCell = (mxCell)mapPlugin2Graph.get(outputPlugin);
                            mxCell outputPortCell = (mxCell)mapOutputPorts2Graph.get(outputPort.getName());
                            MIFilter inputPlugin = inputPort.getParent();
                            mxCell inputPluginCell = (mxCell)mapPlugin2Graph.get(inputPlugin);
                            String inputPortName = inputPort.getName();
                            mxCell inputPortCell = (mxCell)((Map)mapPluginInputPorts2Graph.get(inputPlugin)).get(inputPortName);
                            this.graph.setCellStyles(mxConstants.STYLE_NOLABEL, "0", new Object[]{inputPortCell, outputPortCell});
                            mxCell edge = (mxCell)this.graph.insertEdge(null, null, (Object)"", (Object)outputPluginCell, (Object)inputPluginCell, STYLE_CONNECTION);
                            edge.setSource((mxICell)outputPortCell);
                            edge.setTarget((mxICell)inputPortCell);
                        }
                    }
                    for (MIRepositoryConnector repositoryConnector : outputPlugin.getRepositories()) {
                        if (repositoryConnector.getRepository() == null) continue;
                        MIRepository repository = repositoryConnector.getRepository();
                        mxCell output = (mxCell)mapPlugin2Graph.get(outputPlugin);
                        mxCell input = (mxCell)mapRepository2Graph.get(repository);
                        this.graph.insertEdge(null, null, (Object)repository.getName(), (Object)output, (Object)input, STYLE_CONNECTION_REPOSITORY);
                    }
                }
            }
            finally {
                this.graph.getModel().endUpdate();
            }
        }

        private final Map<String, mxCell> createInputPorts(MIFilter plugin, mxCell vertex) {
            HashMap<String, mxCell> port2graph = new HashMap<String, mxCell>();
            String[] portNames = KaxVizFrame.getAllInputPortNames(plugin);
            for (int i = 0; i < portNames.length; ++i) {
                mxGeometry portGeometry = new mxGeometry(((double)i + 1.0) / (double)(portNames.length + 1), -0.06, 10.0, 10.0);
                portGeometry.setOffset(new mxPoint(0.0, 0.0));
                portGeometry.setRelative(true);
                mxCell port = new mxCell((Object)portNames[i], portGeometry, STYLE_PORT + "spacingTop=3;verticalLabelPosition=bottom;portConstraint=north;" + STYLE_FILTER_COLOR);
                port.setVertex(true);
                this.graph.addCell((Object)port, (Object)vertex);
                port2graph.put(portNames[i], port);
            }
            return port2graph;
        }

        private static String[] convertPortsToNameArray(EList<? extends MIPort> eList) {
            int len = eList.size();
            String[] result = new String[len];
            for (int idx = 0; idx < len; ++idx) {
                result[idx] = ((MIPort)eList.get(idx)).getName();
            }
            return result;
        }

        private static String[] getAllInputPortNames(MIFilter plugin) {
            return KaxVizFrame.convertPortsToNameArray(plugin.getInputPorts());
        }

        private static String[] getAllOutputPortNames(MIPlugin plugin) {
            return KaxVizFrame.convertPortsToNameArray(plugin.getOutputPorts());
        }

        private final Map<String, mxCell> createOutputPorts(MIPlugin plugin, mxCell vertex, boolean reader) {
            HashMap<String, mxCell> port2graph = new HashMap<String, mxCell>();
            String[] portNames = KaxVizFrame.getAllOutputPortNames(plugin);
            for (int i = 0; i < portNames.length; ++i) {
                mxGeometry portGeometry = new mxGeometry(((double)i + 1.0) / (double)(portNames.length + 1), 1.06, 10.0, 10.0);
                portGeometry.setOffset(new mxPoint(0.0, -10.0));
                portGeometry.setRelative(true);
                String fillcolor = reader ? STYLE_READER_COLOR : STYLE_FILTER_COLOR;
                mxCell port = new mxCell((Object)portNames[i], portGeometry, STYLE_PORT + "verticalLabelPosition=top;portConstraint=south;" + fillcolor);
                port.setVertex(true);
                this.graph.addCell((Object)port, (Object)vertex);
                port2graph.put(portNames[i], port);
            }
            return port2graph;
        }

        private static String getShortClassName(MIAnalysisComponent analysisComponent) {
            String className = analysisComponent.getClassname();
            int lastPointPos = className.lastIndexOf(46);
            return className.substring(lastPointPos + 1);
        }

        private final mxCell createReader(MIReader reader, int c) {
            mxCell vertex = new mxCell((Object)("<<Reader>>\n" + reader.getName() + " : " + KaxVizFrame.getShortClassName(reader)), new mxGeometry(30.0, (double)(30 + c * 110), 200.0, 80.0), STYLE_READER);
            vertex.setVertex(true);
            this.graph.addCell((Object)vertex);
            return vertex;
        }

        private final mxCell createFilter(MIFilter plugin, int c) {
            mxCell vertex = new mxCell((Object)("<<Filter>>\n" + plugin.getName() + " : " + KaxVizFrame.getShortClassName(plugin)), new mxGeometry(30.0, (double)(30 + c * 110), 200.0, 80.0), STYLE_FILTER);
            vertex.setVertex(true);
            this.graph.addCell((Object)vertex);
            return vertex;
        }

        private final mxCell createRepository(MIRepository repository, int c) {
            mxCell vertex = new mxCell((Object)("<<Repository>>\n" + repository.getName() + " : " + KaxVizFrame.getShortClassName(repository)), new mxGeometry(30.0, (double)(30 + c * 110), 200.0, 80.0), STYLE_REPOSITORY);
            vertex.setVertex(true);
            this.graph.addCell((Object)vertex);
            return vertex;
        }
    }
}

