/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.traceWriter;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.trace.analysis.filter.AbstractMessageTraceProcessingFilter;
import kieker.tools.trace.analysis.systemModel.MessageTrace;
import kieker.tools.trace.analysis.systemModel.repository.SystemModelRepository;

@Plugin(description="A filter allowing to write the incoming MessageTraces into a configured file", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="outputFn", defaultValue="messageTraces-yyyyMMdd-HHmmssSSS.txt")})
public class MessageTraceWriterFilter
extends AbstractMessageTraceProcessingFilter {
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_FN = "outputFn";
    private static final String ENCODING = "UTF-8";
    private final String outputFn;
    private final PrintStream ps;

    public MessageTraceWriterFilter(Configuration configuration, IProjectContext projectContext) throws IOException {
        super(configuration, projectContext);
        this.outputFn = this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_OUTPUT_FN);
        this.ps = new PrintStream((OutputStream)new FileOutputStream(this.outputFn), false, ENCODING);
    }

    @Override
    public void printStatusMessage() {
        super.printStatusMessage();
        int numTraces = this.getSuccessCount();
        LOGGER.debug("Wrote {} trace{} to file '{}'", numTraces, numTraces > 1 ? "s" : "", this.outputFn);
    }

    @Override
    public void terminate(boolean error) {
        if (this.ps != null) {
            this.ps.close();
        }
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = super.getCurrentConfiguration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_FN, this.outputFn);
        return configuration;
    }

    @Override
    @InputPort(name="messageTraces", description="Receives message traces to be processed", eventTypes={MessageTrace.class})
    public void inputMessageTraces(MessageTrace mt) {
        this.ps.println(mt.toString());
        this.reportSuccess(mt.getTraceId());
    }
}

