/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization.callTree;

import java.io.File;
import java.io.IOException;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.trace.analysis.filter.traceReconstruction.TraceProcessingException;
import kieker.tools.trace.analysis.filter.visualization.callTree.AbstractAggregatedCallTreeNode;
import kieker.tools.trace.analysis.filter.visualization.callTree.AbstractCallTreeFilter;
import kieker.tools.trace.analysis.systemModel.MessageTrace;
import kieker.tools.trace.analysis.systemModel.SynchronousCallMessage;
import kieker.tools.trace.analysis.systemModel.repository.SystemModelRepository;

@Plugin(description="An abstract filter for aggregated call trees", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, configuration={@Property(name="includeWeights", defaultValue="true"), @Property(name="shortLabels", defaultValue="true"), @Property(name="dotOutputFn", defaultValue="calltree.dot")})
public abstract class AbstractAggregatedCallTreeFilter<T>
extends AbstractCallTreeFilter<T> {
    public static final String CONFIG_PROPERTY_NAME_OUTPUT_FILENAME = "dotOutputFn";
    public static final String CONFIG_PROPERTY_NAME_INCLUDE_WEIGHTS = "includeWeights";
    public static final String CONFIG_PROPERTY_NAME_SHORT_LABELS = "shortLabels";
    public static final String CONFIG_PROPERTY_VALUE_OUTPUT_FILENAME_DEFAULT = "calltree.dot";
    public static final String CONFIG_PROPERTY_VALUE_INCLUDE_WEIGHTS_DEFAULT = "true";
    public static final String CONFIG_PROPERTY_VALUE_SHORT_LABELS_DEFAULT = "true";
    private volatile AbstractAggregatedCallTreeNode<T> root;
    private final String dotOutputFile;
    private final boolean includeWeights;
    private final boolean shortLabels;
    private int numGraphsSaved;

    public AbstractAggregatedCallTreeFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.includeWeights = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_INCLUDE_WEIGHTS);
        this.shortLabels = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_SHORT_LABELS);
        this.dotOutputFile = configuration.getPathProperty(CONFIG_PROPERTY_NAME_OUTPUT_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRoot(AbstractAggregatedCallTreeNode<T> root) {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            this.root = root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTreeToDotFile() throws IOException {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            String outputFn = new File(this.dotOutputFile).getCanonicalPath();
            AbstractCallTreeFilter.saveTreeToDotFile(this.root, outputFn, this.includeWeights, false, this.shortLabels);
            ++this.numGraphsSaved;
            this.printDebugLogMessage(new String[]{"Wrote call tree to file '" + outputFn + "'", "Dot file can be converted using the dot tool", "Example: dot -T svg " + outputFn + " > " + outputFn + ".svg"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStatusMessage() {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            super.printStatusMessage();
            LOGGER.debug("Saved {} call tree{}", (Object)this.numGraphsSaved, (Object)(this.numGraphsSaved > 1 ? "s" : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate(boolean error) {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            if (!error) {
                try {
                    this.saveTreeToDotFile();
                }
                catch (IOException ex) {
                    this.logger.error("IOException while saving to dot file", ex);
                }
            }
        }
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = super.getCurrentConfiguration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_INCLUDE_WEIGHTS, Boolean.toString(this.includeWeights));
        configuration.setProperty(CONFIG_PROPERTY_NAME_SHORT_LABELS, Boolean.toString(this.shortLabels));
        configuration.setProperty(CONFIG_PROPERTY_NAME_OUTPUT_FILENAME, this.dotOutputFile);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InputPort(name="messageTraces", description="Receives the message traces to be processed", eventTypes={MessageTrace.class})
    public void inputMessageTraces(MessageTrace trace) {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            try {
                SynchronousCallMessagePairFactory pairFactory = new SynchronousCallMessagePairFactory(this);
                AbstractCallTreeFilter.addTraceToTree(this.root, trace, pairFactory, true);
                this.reportSuccess(trace.getTraceId());
            }
            catch (TraceProcessingException ex) {
                this.logger.error("TraceProcessingException", ex);
                this.reportError(trace.getTraceId());
            }
        }
    }

    protected abstract T concreteCreatePair(SynchronousCallMessage var1);

    private static class SynchronousCallMessagePairFactory<T>
    implements AbstractCallTreeFilter.IPairFactory<T> {
        private final AbstractAggregatedCallTreeFilter<T> filter;

        public SynchronousCallMessagePairFactory(AbstractAggregatedCallTreeFilter<T> filter) {
            this.filter = filter;
        }

        @Override
        public T createPair(SynchronousCallMessage callMsg) {
            return this.filter.concreteCreatePair(callMsg);
        }
    }
}

