/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization.callTree;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.trace.analysis.filter.visualization.callTree.AbstractAggregatedCallTreeFilter;
import kieker.tools.trace.analysis.filter.visualization.callTree.AggregatedAssemblyComponentOperationCallTreeNode;
import kieker.tools.trace.analysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.trace.analysis.filter.visualization.graph.NoOriginRetentionPolicy;
import kieker.tools.trace.analysis.systemModel.AssemblyComponent;
import kieker.tools.trace.analysis.systemModel.Execution;
import kieker.tools.trace.analysis.systemModel.Operation;
import kieker.tools.trace.analysis.systemModel.SynchronousCallMessage;
import kieker.tools.trace.analysis.systemModel.repository.AssemblyComponentOperationPairFactory;
import kieker.tools.trace.analysis.systemModel.repository.SystemModelRepository;
import kieker.tools.trace.analysis.systemModel.util.AssemblyComponentOperationPair;

@Plugin(description="Uses the incoming data to enrich the connected repository with data for the aggregated assembly component operation call tree", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)})
public class AggregatedAssemblyComponentOperationCallTreeFilter
extends AbstractAggregatedCallTreeFilter<AssemblyComponentOperationPair> {
    public AggregatedAssemblyComponentOperationCallTreeFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @Override
    public boolean init() {
        boolean success = super.init();
        if (success) {
            AggregatedAssemblyComponentOperationCallTreeNode root = new AggregatedAssemblyComponentOperationCallTreeNode(0, AssemblyComponentOperationPairFactory.ROOT_PAIR, true, null, (IOriginRetentionPolicy)NoOriginRetentionPolicy.createInstance());
            super.setRoot(root);
        }
        return success;
    }

    @Override
    protected AssemblyComponentOperationPair concreteCreatePair(SynchronousCallMessage callMsg) {
        Execution execution = callMsg.getReceivingExecution();
        AssemblyComponent assemblyComponent = execution.getAllocationComponent().getAssemblyComponent();
        Operation op = execution.getOperation();
        return this.getSystemEntityFactory().getAssemblyPairFactory().getPairInstanceByPair(assemblyComponent, op);
    }
}

