/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization.dependencyGraph;

import kieker.tools.trace.analysis.filter.visualization.AbstractGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.DependencyGraphNode;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.WeightedBidirectionalDependencyGraphEdge;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.trace.analysis.filter.visualization.util.dot.DotFactory;
import kieker.tools.trace.analysis.systemModel.ISystemModelElement;

public abstract class AbstractDependencyGraphFormatterVisitor<T extends ISystemModelElement>
implements AbstractGraph.IGraphVisitor<DependencyGraphNode<T>, WeightedBidirectionalDependencyGraphEdge<T>> {
    protected final StringBuilder builder;
    protected final boolean includeWeights;
    protected final boolean plotLoops;
    protected final boolean useShortLabels;

    public AbstractDependencyGraphFormatterVisitor(StringBuilder builder, boolean includeWeights, boolean plotLoops, boolean useShortLabels) {
        this.builder = builder;
        this.includeWeights = includeWeights;
        this.plotLoops = plotLoops;
        this.useShortLabels = useShortLabels;
    }

    @Override
    public void visitEdge(WeightedBidirectionalDependencyGraphEdge<T> edge) {
        DependencyGraphNode destinationNode;
        DependencyGraphNode sourceNode = (DependencyGraphNode)edge.getSource();
        if (sourceNode.equals(destinationNode = (DependencyGraphNode)edge.getTarget()) && !this.plotLoops) {
            return;
        }
        String lineStyle = edge.isAssumed() ? "dashed" : "solid";
        String color = AbstractGraphFormatter.getDotRepresentation(edge.getColor());
        if (this.includeWeights) {
            this.builder.append(DotFactory.createConnection("", AbstractDependencyGraphFormatter.createNodeId(sourceNode), AbstractDependencyGraphFormatter.createNodeId(destinationNode), Integer.toString(edge.getTargetWeight().get()), lineStyle, "open", color));
        } else {
            this.builder.append(DotFactory.createConnection("", AbstractDependencyGraphFormatter.createNodeId(sourceNode), AbstractDependencyGraphFormatter.createNodeId(destinationNode), lineStyle, "open", color));
        }
        this.builder.append("\n");
    }
}

