/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization.dependencyGraph;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.AbstractDependencyGraph;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFilter;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.ContainerDependencyGraph;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.DependencyGraphNode;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.trace.analysis.systemModel.AbstractMessage;
import kieker.tools.trace.analysis.systemModel.AllocationComponent;
import kieker.tools.trace.analysis.systemModel.ExecutionContainer;
import kieker.tools.trace.analysis.systemModel.MessageTrace;
import kieker.tools.trace.analysis.systemModel.SynchronousReplyMessage;
import kieker.tools.trace.analysis.systemModel.repository.ExecutionEnvironmentRepository;
import kieker.tools.trace.analysis.systemModel.repository.SystemModelRepository;

@Plugin(repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, outputPorts={@OutputPort(name="graphs", eventTypes={AbstractGraph.class})})
public class ContainerDependencyGraphFilter
extends AbstractDependencyGraphFilter<ExecutionContainer> {
    private static final String CONFIGURATION_NAME = "Container dependency graph";

    public ContainerDependencyGraphFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext, new ContainerDependencyGraph(ExecutionEnvironmentRepository.ROOT_EXECUTION_CONTAINER));
    }

    @Override
    @InputPort(name="messageTraces", description="Receives the message traces to be processed", eventTypes={MessageTrace.class})
    public void inputMessageTraces(MessageTrace t) {
        for (AbstractMessage m : t.getSequenceAsVector()) {
            if (m instanceof SynchronousReplyMessage) continue;
            AllocationComponent senderComponent = m.getSendingExecution().getAllocationComponent();
            AllocationComponent receiverComponent = m.getReceivingExecution().getAllocationComponent();
            ExecutionContainer senderContainer = senderComponent.getExecutionContainer();
            ExecutionContainer receiverContainer = receiverComponent.getExecutionContainer();
            DependencyGraphNode<Object> senderNode = ((AbstractDependencyGraph)this.getGraph()).getNode(senderContainer.getId());
            DependencyGraphNode<Object> receiverNode = ((AbstractDependencyGraph)this.getGraph()).getNode(receiverContainer.getId());
            if (senderNode == null) {
                senderNode = new DependencyGraphNode<ExecutionContainer>(senderContainer.getId(), senderContainer, t.getTraceInformation(), this.getOriginRetentionPolicy());
                ((AbstractDependencyGraph)this.getGraph()).addNode(senderContainer.getId(), senderNode);
            } else {
                this.handleOrigin(senderNode, t.getTraceInformation());
            }
            if (receiverNode == null) {
                receiverNode = new DependencyGraphNode<ExecutionContainer>(receiverContainer.getId(), receiverContainer, t.getTraceInformation(), this.getOriginRetentionPolicy());
                ((AbstractDependencyGraph)this.getGraph()).addNode(receiverContainer.getId(), receiverNode);
            } else {
                this.handleOrigin(receiverNode, t.getTraceInformation());
            }
            senderNode.addOutgoingDependency(receiverNode, t.getTraceInformation(), this.getOriginRetentionPolicy());
            receiverNode.addIncomingDependency(senderNode, t.getTraceInformation(), this.getOriginRetentionPolicy());
        }
        this.reportSuccess(t.getTraceId());
    }

    @Override
    public String getConfigurationName() {
        return CONFIGURATION_NAME;
    }
}

