/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization.dependencyGraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.WeightedBidirectionalDependencyGraphEdge;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractPayloadedVertex;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractVertexDecoration;
import kieker.tools.trace.analysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.trace.analysis.systemModel.ISystemModelElement;
import kieker.tools.trace.analysis.systemModel.TraceInformation;

public class DependencyGraphNode<T extends ISystemModelElement>
extends AbstractPayloadedVertex<DependencyGraphNode<T>, WeightedBidirectionalDependencyGraphEdge<T>, TraceInformation, T> {
    public static final int ROOT_NODE_ID = 0;
    private final int id;
    private final Map<Integer, WeightedBidirectionalDependencyGraphEdge<T>> incomingDependencies = new ConcurrentHashMap<Integer, WeightedBidirectionalDependencyGraphEdge<T>>();
    private final Map<Integer, WeightedBidirectionalDependencyGraphEdge<T>> outgoingDependencies = new ConcurrentHashMap<Integer, WeightedBidirectionalDependencyGraphEdge<T>>();
    private final Map<Integer, WeightedBidirectionalDependencyGraphEdge<T>> assumedIncomingDependencies = new ConcurrentHashMap<Integer, WeightedBidirectionalDependencyGraphEdge<T>>();
    private final Map<Integer, WeightedBidirectionalDependencyGraphEdge<T>> assumedOutgoingDependencies = new ConcurrentHashMap<Integer, WeightedBidirectionalDependencyGraphEdge<T>>();
    private volatile boolean assumed;

    public DependencyGraphNode(int id, T entity, TraceInformation origin, IOriginRetentionPolicy originPolicy) {
        super(origin, originPolicy, entity);
        this.id = id;
    }

    public final T getEntity() {
        return (T)((ISystemModelElement)this.getPayload());
    }

    @Override
    public String getIdentifier() {
        return this.getEntity().getIdentifier();
    }

    public final Collection<WeightedBidirectionalDependencyGraphEdge<T>> getIncomingDependencies() {
        return this.incomingDependencies.values();
    }

    public final Collection<WeightedBidirectionalDependencyGraphEdge<T>> getOutgoingDependencies() {
        return this.outgoingDependencies.values();
    }

    public Collection<WeightedBidirectionalDependencyGraphEdge<T>> getAssumedIncomingDependencies() {
        return this.assumedIncomingDependencies.values();
    }

    public Collection<WeightedBidirectionalDependencyGraphEdge<T>> getAssumedOutgoingDependencies() {
        return this.assumedOutgoingDependencies.values();
    }

    public void setAssumed() {
        this.assumed = true;
    }

    public boolean isAssumed() {
        return this.assumed;
    }

    public void addOutgoingDependency(DependencyGraphNode<T> destination, TraceInformation origin, IOriginRetentionPolicy originPolicy) {
        this.addOutgoingDependency(destination, false, origin, originPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutgoingDependency(DependencyGraphNode<T> destination, boolean isAssumed, TraceInformation origin, IOriginRetentionPolicy originPolicy) {
        DependencyGraphNode dependencyGraphNode = this;
        synchronized (dependencyGraphNode) {
            Map<Integer, WeightedBidirectionalDependencyGraphEdge<T>> relevantDependencies = isAssumed ? this.assumedOutgoingDependencies : this.outgoingDependencies;
            WeightedBidirectionalDependencyGraphEdge<T> e = relevantDependencies.get(destination.getId());
            if (e == null) {
                e = new WeightedBidirectionalDependencyGraphEdge<T>(this, destination, origin, originPolicy);
                if (isAssumed) {
                    e.setAssumed();
                }
                relevantDependencies.put(destination.getId(), e);
            } else {
                originPolicy.handleOrigin(e, origin);
            }
            e.getTargetWeight().incrementAndGet();
        }
    }

    public void addIncomingDependency(DependencyGraphNode<T> source, TraceInformation origin, IOriginRetentionPolicy originPolicy) {
        this.addIncomingDependency(source, false, origin, originPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncomingDependency(DependencyGraphNode<T> source, boolean isAssumed, TraceInformation origin, IOriginRetentionPolicy originPolicy) {
        DependencyGraphNode dependencyGraphNode = this;
        synchronized (dependencyGraphNode) {
            Map<Integer, WeightedBidirectionalDependencyGraphEdge<T>> relevantDependencies = isAssumed ? this.assumedIncomingDependencies : this.incomingDependencies;
            WeightedBidirectionalDependencyGraphEdge<T> e = relevantDependencies.get(source.getId());
            if (e == null) {
                e = new WeightedBidirectionalDependencyGraphEdge<T>(this, source, origin, originPolicy);
                relevantDependencies.put(source.getId(), e);
            } else {
                originPolicy.handleOrigin(e, origin);
            }
            e.getSourceWeight().incrementAndGet();
        }
    }

    public final int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormattedDecorations() {
        DependencyGraphNode dependencyGraphNode = this;
        synchronized (dependencyGraphNode) {
            StringBuilder builder = new StringBuilder();
            Iterator<AbstractVertexDecoration> decorationsIter = this.getDecorations().iterator();
            while (decorationsIter.hasNext()) {
                String currentDecorationText = decorationsIter.next().createFormattedOutput();
                if (currentDecorationText == null || currentDecorationText.length() == 0) continue;
                builder.append(currentDecorationText);
                if (!decorationsIter.hasNext()) continue;
                builder.append("\\n");
            }
            return builder.toString();
        }
    }

    @Override
    public Collection<WeightedBidirectionalDependencyGraphEdge<T>> getOutgoingEdges() {
        ArrayList<WeightedBidirectionalDependencyGraphEdge<T>> edges = new ArrayList<WeightedBidirectionalDependencyGraphEdge<T>>();
        edges.addAll(this.getOutgoingDependencies());
        edges.addAll(this.getAssumedOutgoingDependencies());
        return edges;
    }
}

