/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization.dependencyGraph;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.tools.trace.analysis.filter.visualization.AbstractGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFormatterVisitor;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.AbstractOperationDependencyGraphFormatter;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.DependencyGraphNode;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.OperationAllocationDependencyGraph;
import kieker.tools.trace.analysis.filter.visualization.util.dot.DotFactory;
import kieker.tools.trace.analysis.systemModel.AllocationComponent;
import kieker.tools.trace.analysis.systemModel.ExecutionContainer;
import kieker.tools.trace.analysis.systemModel.Operation;
import kieker.tools.trace.analysis.systemModel.util.AllocationComponentOperationPair;

public class OperationAllocationDependencyGraphFormatter
extends AbstractOperationDependencyGraphFormatter<OperationAllocationDependencyGraph> {
    private static final String DEFAULT_FILE_NAME = "deploymentOperationDependencyGraph.dot";

    private ElementGrouping groupElements(OperationAllocationDependencyGraph graph) {
        ConcurrentHashMap<ExecutionContainer, Set<AllocationComponent>> allocationComponentGrouping = new ConcurrentHashMap<ExecutionContainer, Set<AllocationComponent>>();
        ConcurrentHashMap<AllocationComponent, Set<DependencyGraphNode<AllocationComponentOperationPair>>> operationGrouping = new ConcurrentHashMap<AllocationComponent, Set<DependencyGraphNode<AllocationComponentOperationPair>>>();
        for (DependencyGraphNode vertex : graph.getVertices()) {
            AllocationComponent allocationComponent = ((AllocationComponentOperationPair)vertex.getEntity()).getAllocationComponent();
            ExecutionContainer executionContainer = allocationComponent.getExecutionContainer();
            HashSet<AllocationComponent> allocationComponents = (HashSet<AllocationComponent>)allocationComponentGrouping.get(executionContainer);
            if (allocationComponents == null) {
                allocationComponents = new HashSet<AllocationComponent>();
                allocationComponentGrouping.put(executionContainer, allocationComponents);
            }
            allocationComponents.add(allocationComponent);
            HashSet operations = (HashSet)operationGrouping.get(allocationComponent);
            if (operations == null) {
                operations = new HashSet();
                operationGrouping.put(allocationComponent, operations);
            }
            operations.add(vertex);
        }
        return new ElementGrouping(allocationComponentGrouping, operationGrouping);
    }

    private static String createContainerNodeLabel(ExecutionContainer container) {
        return "<<execution container>>\\n" + container.getName();
    }

    private static String createAllocationComponentNodeLabel(AllocationComponent component, boolean useShortLabels) {
        StringBuilder builder = new StringBuilder();
        builder.append("<<deployment component>>").append("\\n").append(component.getAssemblyComponent().getName()).append(':');
        if (useShortLabels) {
            builder.append("..");
        } else {
            builder.append(component.getAssemblyComponent().getType().getPackageName()).append('.');
        }
        builder.append(component.getAssemblyComponent().getType().getTypeName());
        return builder.toString();
    }

    private void createGraph(ElementGrouping grouping, StringBuilder builder, boolean useShortLabels) {
        ConcurrentMap<ExecutionContainer, Set<AllocationComponent>> allocationComponentGrouping = grouping.getAllocationComponentGrouping();
        ConcurrentMap<AllocationComponent, Set<DependencyGraphNode<AllocationComponentOperationPair>>> operationGrouping = grouping.getOperationGrouping();
        for (Map.Entry containerComponentEntry : allocationComponentGrouping.entrySet()) {
            ExecutionContainer executionContainer = (ExecutionContainer)containerComponentEntry.getKey();
            if (executionContainer.isRootContainer()) {
                builder.append((CharSequence)DotFactory.createNode("", AbstractDependencyGraphFormatter.createNodeId(executionContainer.getId()), executionContainer.getName(), "none", null, null, null, null, 0.0, null, null, null));
                continue;
            }
            builder.append((CharSequence)DotFactory.createCluster("", AbstractDependencyGraphFormatter.createContainerId(executionContainer), OperationAllocationDependencyGraphFormatter.createContainerNodeLabel(executionContainer), "box", "filled", null, "white", null, 0.0, null));
            for (AllocationComponent allocationComponent : (Set)containerComponentEntry.getValue()) {
                builder.append((CharSequence)DotFactory.createCluster("", AbstractDependencyGraphFormatter.createAllocationComponentId(allocationComponent), OperationAllocationDependencyGraphFormatter.createAllocationComponentNodeLabel(allocationComponent, useShortLabels), "box", "filled", null, "white", null, 0.0, null));
                for (DependencyGraphNode node : (Set)operationGrouping.get(allocationComponent)) {
                    Operation operation = ((AllocationComponentOperationPair)node.getEntity()).getOperation();
                    builder.append((CharSequence)DotFactory.createNode("", AbstractDependencyGraphFormatter.createNodeId(node), this.createOperationNodeLabel(operation, node), "oval", "filled", AbstractGraphFormatter.getDotRepresentation(node.getColor()), AbstractDependencyGraphFormatter.getNodeFillColor(node), null, 0.0, null, null, node.getDescription()));
                }
                builder.append("}\n");
            }
            builder.append("}\n");
        }
    }

    @Override
    protected String formatDependencyGraph(OperationAllocationDependencyGraph graph, boolean includeWeights, boolean useShortLabels, boolean plotLoops) {
        StringBuilder builder = new StringBuilder();
        this.appendGraphHeader(builder);
        ElementGrouping grouping = this.groupElements(graph);
        this.createGraph(grouping, builder, useShortLabels);
        graph.traverseWithVerticesFirst(new EdgeVisitor(builder, includeWeights, plotLoops, useShortLabels));
        this.appendGraphFooter(builder);
        return builder.toString();
    }

    @Override
    public String getDefaultFileName() {
        return DEFAULT_FILE_NAME;
    }

    private static class EdgeVisitor
    extends AbstractDependencyGraphFormatterVisitor<AllocationComponentOperationPair> {
        public EdgeVisitor(StringBuilder builder, boolean includeWeights, boolean plotLoops, boolean useShortLabels) {
            super(builder, includeWeights, plotLoops, useShortLabels);
        }

        @Override
        public void visitVertex(DependencyGraphNode<AllocationComponentOperationPair> vertex) {
        }
    }

    private static class ElementGrouping {
        private final ConcurrentMap<ExecutionContainer, Set<AllocationComponent>> allocationComponentGrouping;
        private final ConcurrentMap<AllocationComponent, Set<DependencyGraphNode<AllocationComponentOperationPair>>> operationGrouping;

        public ElementGrouping(ConcurrentMap<ExecutionContainer, Set<AllocationComponent>> allocationComponentGrouping, ConcurrentMap<AllocationComponent, Set<DependencyGraphNode<AllocationComponentOperationPair>>> operationGrouping) {
            this.allocationComponentGrouping = allocationComponentGrouping;
            this.operationGrouping = operationGrouping;
        }

        public ConcurrentMap<ExecutionContainer, Set<AllocationComponent>> getAllocationComponentGrouping() {
            return this.allocationComponentGrouping;
        }

        public ConcurrentMap<AllocationComponent, Set<DependencyGraphNode<AllocationComponentOperationPair>>> getOperationGrouping() {
            return this.operationGrouping;
        }
    }
}

