/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization.dependencyGraph;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.AbstractDependencyGraph;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFilter;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.DependencyGraphNode;
import kieker.tools.trace.analysis.filter.visualization.dependencyGraph.OperationAssemblyDependencyGraph;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.trace.analysis.systemModel.AbstractMessage;
import kieker.tools.trace.analysis.systemModel.AssemblyComponent;
import kieker.tools.trace.analysis.systemModel.MessageTrace;
import kieker.tools.trace.analysis.systemModel.Operation;
import kieker.tools.trace.analysis.systemModel.SynchronousReplyMessage;
import kieker.tools.trace.analysis.systemModel.repository.AssemblyComponentOperationPairFactory;
import kieker.tools.trace.analysis.systemModel.repository.AssemblyRepository;
import kieker.tools.trace.analysis.systemModel.repository.OperationRepository;
import kieker.tools.trace.analysis.systemModel.repository.SystemModelRepository;
import kieker.tools.trace.analysis.systemModel.util.AssemblyComponentOperationPair;

@Plugin(repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, outputPorts={@OutputPort(name="graphs", eventTypes={AbstractGraph.class})})
public class OperationDependencyGraphAssemblyFilter
extends AbstractDependencyGraphFilter<AssemblyComponentOperationPair> {
    private static final String CONFIGURATION_NAME = "Operation dependency graph (assembly level)";

    public OperationDependencyGraphAssemblyFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext, new OperationAssemblyDependencyGraph(new AssemblyComponentOperationPair(0, OperationRepository.ROOT_OPERATION, AssemblyRepository.ROOT_ASSEMBLY_COMPONENT)));
    }

    @Override
    @InputPort(name="messageTraces", description="Receives the message traces to be processed", eventTypes={MessageTrace.class})
    public void inputMessageTraces(MessageTrace t) {
        for (AbstractMessage m : t.getSequenceAsVector()) {
            if (m instanceof SynchronousReplyMessage) continue;
            AssemblyComponent senderComponent = m.getSendingExecution().getAllocationComponent().getAssemblyComponent();
            AssemblyComponent receiverComponent = m.getReceivingExecution().getAllocationComponent().getAssemblyComponent();
            int rootOperationId = OperationRepository.ROOT_OPERATION.getId();
            Operation senderOperation = m.getSendingExecution().getOperation();
            Operation receiverOperation = m.getReceivingExecution().getOperation();
            AssemblyComponentOperationPairFactory pairFactory = this.getSystemEntityFactory().getAssemblyPairFactory();
            AssemblyComponentOperationPair senderPair = senderOperation.getId() == rootOperationId ? (AssemblyComponentOperationPair)((AbstractDependencyGraph)this.getGraph()).getRootNode().getEntity() : pairFactory.getPairInstanceByPair(senderComponent, senderOperation);
            AssemblyComponentOperationPair receiverPair = receiverOperation.getId() == rootOperationId ? (AssemblyComponentOperationPair)((AbstractDependencyGraph)this.getGraph()).getRootNode().getEntity() : pairFactory.getPairInstanceByPair(receiverComponent, receiverOperation);
            DependencyGraphNode<Object> senderNode = ((AbstractDependencyGraph)this.getGraph()).getNode(senderPair.getId());
            DependencyGraphNode<Object> receiverNode = ((AbstractDependencyGraph)this.getGraph()).getNode(receiverPair.getId());
            if (senderNode == null) {
                senderNode = new DependencyGraphNode<AssemblyComponentOperationPair>(senderPair.getId(), senderPair, t.getTraceInformation(), this.getOriginRetentionPolicy());
                if (m.getSendingExecution().isAssumed()) {
                    senderNode.setAssumed();
                }
                ((AbstractDependencyGraph)this.getGraph()).addNode(senderNode.getId(), senderNode);
            } else {
                this.handleOrigin(senderNode, t.getTraceInformation());
            }
            if (receiverNode == null) {
                receiverNode = new DependencyGraphNode<AssemblyComponentOperationPair>(receiverPair.getId(), receiverPair, t.getTraceInformation(), this.getOriginRetentionPolicy());
                if (m.getReceivingExecution().isAssumed()) {
                    receiverNode.setAssumed();
                }
                ((AbstractDependencyGraph)this.getGraph()).addNode(receiverNode.getId(), receiverNode);
            } else {
                this.handleOrigin(receiverNode, t.getTraceInformation());
            }
            boolean assumed = this.isDependencyAssumed(senderNode, receiverNode);
            senderNode.addOutgoingDependency(receiverNode, assumed, t.getTraceInformation(), this.getOriginRetentionPolicy());
            receiverNode.addIncomingDependency(senderNode, assumed, t.getTraceInformation(), this.getOriginRetentionPolicy());
            this.invokeDecorators(m, senderNode, receiverNode);
        }
        this.reportSuccess(t.getTraceId());
    }

    @Override
    public String getConfigurationName() {
        return CONFIGURATION_NAME;
    }
}

