/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CLIHelpFormatter
extends HelpFormatter {
    @Override
    protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad) {
        String lpad = this.createPadding(leftPad);
        String dpad = this.createPadding(8);
        ArrayList<Option> optList = new ArrayList<Option>(options.getOptions());
        Collections.sort(optList, this.getOptionComparator());
        Iterator i = optList.iterator();
        while (i.hasNext()) {
            Option option = (Option)i.next();
            StringBuilder optBuf = new StringBuilder(8);
            if (option.getOpt() == null) {
                optBuf.append(lpad).append("   ").append(this.getLongOptPrefix()).append(option.getLongOpt());
            } else {
                optBuf.append(lpad).append(this.getOptPrefix()).append(option.getOpt());
                if (option.hasLongOpt()) {
                    optBuf.append(',').append(this.getLongOptPrefix()).append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                if (option.hasArgName()) {
                    optBuf.append(" <").append(option.getArgName()).append('>');
                } else {
                    optBuf.append(' ');
                }
            }
            sb.append(optBuf.toString()).append(this.getNewLine());
            optBuf = new StringBuilder();
            optBuf.append(dpad);
            if (option.getDescription() != null) {
                optBuf.append(option.getDescription());
            }
            this.renderWrappedText(sb, width, dpad.length(), optBuf.toString());
            if (!i.hasNext()) continue;
            sb.append(this.getNewLine());
            sb.append(this.getNewLine());
        }
        return sb;
    }
}

