/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolsUtil.class);

    private ToolsUtil() {
    }

    public static void loadVerboseLogger() {
        ToolsUtil.loadLogger("logging.verbose.properties");
    }

    public static void loadDebugLogger() {
        ToolsUtil.loadLogger("logging.debug.properties");
    }

    public static void loadDefaultLogger() {
        ToolsUtil.loadLogger("logging.properties");
    }

    private static void loadLogger(String loggerProperties) {
        try {
            LogManager logManager = LogManager.getLogManager();
            InputStream configStream = ClassLoader.getSystemClassLoader().getResourceAsStream(loggerProperties);
            if (configStream != null) {
                logManager.readConfiguration(configStream);
            } else {
                LOGGER.warn("Could not load verbose/debug logger");
            }
        }
        catch (SecurityException ex) {
            LOGGER.warn("Could not load verbose/debug logger", ex);
        }
        catch (IOException ex) {
            LOGGER.warn("Could not load verbose/debug logger", ex);
        }
    }
}

