/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.graph.dependency;

import java.time.temporal.ChronoUnit;
import kieker.analysis.graph.IEdge;
import kieker.analysis.graph.IGraph;
import kieker.analysis.graph.IVertex;
import kieker.analysis.graph.dependency.IDependencyGraphBuilder;
import kieker.analysis.graph.dependency.ResponseTimeDecorator;
import kieker.analysis.graph.dependency.vertextypes.VertexType;
import kieker.analysis.stage.model.ModelRepository;
import kieker.analysis.util.ObjectIdentifierRegistry;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.execution.AggregatedInvocation;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.statistics.EPredefinedUnits;
import kieker.model.analysismodel.statistics.EPropertyType;
import kieker.model.analysismodel.statistics.StatisticRecord;
import kieker.model.analysismodel.statistics.Statistics;
import kieker.model.analysismodel.statistics.StatisticsModel;
import kieker.model.analysismodel.util.ComposedKey;

public abstract class AbstractDependencyGraphBuilder
implements IDependencyGraphBuilder {
    private static final Object ENTRY_VERTEX_IDENTIFIER = "entry";
    protected IGraph graph;
    protected ObjectIdentifierRegistry identifierRegistry;
    protected ResponseTimeDecorator responseTimeDecorator;
    protected ExecutionModel executionModel;
    protected StatisticsModel statisticsModel;

    @Override
    public IGraph build(ModelRepository repository) {
        this.graph = IGraph.create();
        this.graph.setName(repository.getName());
        this.executionModel = repository.getModel(ExecutionModel.class);
        this.statisticsModel = repository.getModel(StatisticsModel.class);
        this.identifierRegistry = new ObjectIdentifierRegistry();
        this.responseTimeDecorator = new ResponseTimeDecorator(this.statisticsModel, ChronoUnit.NANOS);
        for (AggregatedInvocation invocation : this.executionModel.getAggregatedInvocations().values()) {
            this.handleInvocation(invocation);
        }
        return this.graph;
    }

    private void handleInvocation(AggregatedInvocation invocation) {
        IVertex sourceVertex = invocation.getSource() != null ? this.addVertex(invocation.getSource()) : this.addVertexForEntry();
        IVertex targetVertex = this.addVertex(invocation.getTarget());
        long calls = (Long)((StatisticRecord)((Statistics)this.statisticsModel.getStatistics().get((Object)invocation)).getStatistics().get((Object)EPredefinedUnits.INVOCATION)).getProperties().get((Object)EPropertyType.COUNT);
        this.addEdge(sourceVertex, targetVertex, calls);
    }

    protected abstract IVertex addVertex(DeployedOperation var1);

    protected IVertex addVertexForEntry() {
        int id = this.identifierRegistry.getIdentifier(ENTRY_VERTEX_IDENTIFIER);
        IVertex vertex = this.graph.addVertexIfAbsent(id);
        vertex.setPropertyIfAbsent("type", (Object)VertexType.ENTRY);
        vertex.setProperty("name", ENTRY_VERTEX_IDENTIFIER);
        return vertex;
    }

    protected IEdge addEdge(IVertex source, IVertex target, long calls) {
        int edgeId = this.identifierRegistry.getIdentifier(ComposedKey.of(source, target));
        IEdge edge = source.addEdgeIfAbsent(edgeId, target);
        edge.setPropertyIfAbsent("calls", calls);
        return edge;
    }
}

