/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.graph.export.graphml;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Function;
import kieker.analysis.graph.IGraph;
import kieker.analysis.graph.export.graphml.GraphMLWriterStage;
import kieker.analysis.graph.mapping.SimpleFileNameMapper;
import kieker.analysis.graph.util.FileExtension;

public class GraphMLFileWriterStage
extends GraphMLWriterStage {
    public GraphMLFileWriterStage(Function<IGraph, Path> fileNameMapper) {
        super(fileNameMapper.andThen(fileName -> {
            try {
                return Files.newOutputStream(fileName, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }));
    }

    public GraphMLFileWriterStage(Path outputDirectory) {
        this(new SimpleFileNameMapper(outputDirectory, FileExtension.GRAPHML));
    }
}

