/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.flow;

import java.util.HashMap;
import java.util.Map;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.flow.thread.AfterFailedThreadBasedEvent;
import kieker.common.record.flow.thread.AfterThreadBasedEvent;
import kieker.common.record.flow.thread.BeforeThreadBasedEvent;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.misc.ThreadMetaData;

@Deprecated
@Plugin(name="Thread Event to Trace Event Filter (Event)", description="Filter to transform threadId-based events to traceId-based events", outputPorts={@OutputPort(name="defaultOutputPort", description="Outputs monitoring records", eventTypes={IMonitoringRecord.class})})
public class ThreadEvent2TraceEventFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_DEFAULT = "defaultInputPort";
    public static final String OUTPUT_PORT_NAME_DEFAULT = "defaultOutputPort";
    private final Map<Long, String> hostNames = new HashMap<Long, String>();
    private final Map<Long, MonitoredTrace> monitoredTraces = new HashMap<Long, MonitoredTrace>();
    private int currentTraceId;

    public ThreadEvent2TraceEventFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @InputPort(name="defaultInputPort", description="Input port for a threadId-based event", eventTypes={IMonitoringRecord.class})
    public void readInput(IMonitoringRecord event) {
        if (event instanceof BeforeThreadBasedEvent) {
            BeforeThreadBasedEvent originalEvent = (BeforeThreadBasedEvent)event;
            MonitoredTrace monitoredTrace = this.getOrCreateMonitoredThread(originalEvent.getLoggingTimestamp(), originalEvent.getThreadId());
            BeforeOperationEvent newEvent = new BeforeOperationEvent(originalEvent.getTimestamp(), monitoredTrace.identifier, originalEvent.getOrderIndex(), originalEvent.getOperationSignature(), originalEvent.getClassSignature());
            newEvent.setLoggingTimestamp(originalEvent.getLoggingTimestamp());
            super.deliver(OUTPUT_PORT_NAME_DEFAULT, newEvent);
        } else if (event instanceof AfterThreadBasedEvent) {
            AfterThreadBasedEvent originalEvent = (AfterThreadBasedEvent)event;
            MonitoredTrace monitoredTrace = this.getMonitoredThread(originalEvent.getThreadId());
            AfterOperationEvent newEvent = new AfterOperationEvent(originalEvent.getTimestamp(), monitoredTrace.identifier, originalEvent.getOrderIndex(), originalEvent.getOperationSignature(), originalEvent.getClassSignature());
            newEvent.setLoggingTimestamp(originalEvent.getLoggingTimestamp());
            super.deliver(OUTPUT_PORT_NAME_DEFAULT, newEvent);
        } else if (event instanceof AfterFailedThreadBasedEvent) {
            AfterFailedThreadBasedEvent originalEvent = (AfterFailedThreadBasedEvent)event;
            MonitoredTrace monitoredTrace = this.getMonitoredThread(originalEvent.getThreadId());
            AfterOperationFailedEvent newEvent = new AfterOperationFailedEvent(originalEvent.getTimestamp(), monitoredTrace.identifier, originalEvent.getOrderIndex(), originalEvent.getOperationSignature(), originalEvent.getClassSignature(), originalEvent.getCause());
            newEvent.setLoggingTimestamp(originalEvent.getLoggingTimestamp());
            super.deliver(OUTPUT_PORT_NAME_DEFAULT, newEvent);
        } else if (event instanceof ThreadMetaData) {
            ThreadMetaData threadMetaData = (ThreadMetaData)event;
            long threadId = threadMetaData.getThreadId();
            String hostName = threadMetaData.getHostname();
            this.hostNames.put(threadId, hostName);
        } else {
            super.deliver(OUTPUT_PORT_NAME_DEFAULT, event);
        }
    }

    private MonitoredTrace getOrCreateMonitoredThread(long beforeEventLoggingTimestamp, long threadId) {
        MonitoredTrace monitoredTrace;
        if (!this.monitoredTraces.containsKey(threadId)) {
            int uniqueTraceId = this.currentTraceId++;
            monitoredTrace = new MonitoredTrace(uniqueTraceId);
            monitoredTrace.currentStackSize = 0;
            this.monitoredTraces.put(threadId, monitoredTrace);
            long synthesizedLoggingTimestamp = beforeEventLoggingTimestamp - 1L;
            String hostName = this.hostNames.get(threadId);
            TraceMetadata traceMetadata = new TraceMetadata(monitoredTrace.identifier, threadId, "<NO SESSION>", hostName, -1L, -1);
            traceMetadata.setLoggingTimestamp(synthesizedLoggingTimestamp);
            super.deliver(OUTPUT_PORT_NAME_DEFAULT, traceMetadata);
        } else {
            monitoredTrace = this.monitoredTraces.get(threadId);
        }
        ++monitoredTrace.currentStackSize;
        return monitoredTrace;
    }

    private MonitoredTrace getMonitoredThread(long threadId) {
        MonitoredTrace monitoredTrace = this.monitoredTraces.get(threadId);
        --monitoredTrace.currentStackSize;
        if (monitoredTrace.currentStackSize == 0) {
            this.monitoredTraces.remove(threadId);
        }
        return monitoredTrace;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        return new Configuration(this.configuration);
    }

    private static class MonitoredTrace {
        public final int identifier;
        public int currentStackSize;

        public MonitoredTrace(int identifier) {
            this.identifier = identifier;
        }
    }
}

