/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.newio.deserializer;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.reader.newio.deserializer.AbstractContainerFormatDeserializer;
import kieker.analysis.plugin.reader.newio.deserializer.DeserializerStringRegistry;
import kieker.analysis.plugin.reader.newio.deserializer.InvalidFormatException;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.BinaryValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import kieker.common.util.dataformat.FormatIdentifier;
import kieker.common.util.dataformat.VariableLengthEncoding;

public class BinaryDeserializer
extends AbstractContainerFormatDeserializer {
    public static final int FORMAT_IDENTIFIER = FormatIdentifier.DEFAULT_BINARY_FORMAT.getIdentifierValue();
    private static final String ENCODING_NAME = "UTF-8";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final CachedRecordFactoryCatalog cachedRecordFactoryCatalog = CachedRecordFactoryCatalog.getInstance();

    public BinaryDeserializer(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @Override
    protected int getFormatIdentifier() {
        return FORMAT_IDENTIFIER;
    }

    @Override
    protected List<IMonitoringRecord> decodeRecords(ByteBuffer buffer, int dataSize) throws InvalidFormatException {
        int baseOffset = buffer.position();
        buffer.position(baseOffset + dataSize - 4);
        int stringTableOffset = buffer.getInt();
        int absoluteStringTableOffset = baseOffset + stringTableOffset;
        buffer.position(absoluteStringTableOffset);
        ReaderRegistry<String> stringRegistry = this.decodeStringRegistry(buffer);
        buffer.position(baseOffset);
        return this.decodeMonitoringRecords(buffer, stringRegistry, absoluteStringTableOffset);
    }

    private ReaderRegistry<String> decodeStringRegistry(ByteBuffer buffer) {
        int numberOfEntries = VariableLengthEncoding.decodeInt(buffer);
        ArrayList<String> values = new ArrayList<String>(numberOfEntries);
        for (int entryIndex = 0; entryIndex < numberOfEntries; ++entryIndex) {
            int entryLength = VariableLengthEncoding.decodeInt(buffer);
            byte[] entryDataBytes = new byte[entryLength];
            buffer.get(entryDataBytes);
            String entryData = new String(entryDataBytes, CHARSET);
            values.add(entryData);
        }
        return new DeserializerStringRegistry(values);
    }

    private List<IMonitoringRecord> decodeMonitoringRecords(ByteBuffer buffer, ReaderRegistry<String> stringRegistry, int endOffset) {
        ArrayList<IMonitoringRecord> records = new ArrayList<IMonitoringRecord>();
        int currentOffset = buffer.position();
        CachedRecordFactoryCatalog recordFactoryCatalog = this.cachedRecordFactoryCatalog;
        while (currentOffset < endOffset) {
            int recordTypeId = buffer.getInt();
            String recordTypeName = stringRegistry.get(recordTypeId);
            long loggingTimestamp = buffer.getLong();
            IRecordFactory<? extends IMonitoringRecord> recordFactory = recordFactoryCatalog.get(recordTypeName);
            IMonitoringRecord record = recordFactory.create(BinaryValueDeserializer.create(buffer, stringRegistry));
            record.setLoggingTimestamp(loggingTimestamp);
            records.add(record);
            currentOffset = buffer.position();
        }
        if (currentOffset != endOffset) {
            throw new InvalidFormatException("Invalid record data found, should have ended at offset " + endOffset + ", but ended at offset " + currentOffset + ".");
        }
        return records;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void terminate() {
    }
}

