/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.tcp;

import java.nio.ByteBuffer;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.BinaryValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import kieker.monitoring.core.controller.tcp.AbstractTcpReader;
import org.slf4j.Logger;

@Deprecated
public abstract class AbstractRecordTcpReader
extends AbstractTcpReader {
    private static final int INT_BYTES = 4;
    private static final int LONG_BYTES = 8;
    private final CachedRecordFactoryCatalog recordFactories;
    private final ReaderRegistry<String> stringRegistry;

    public AbstractRecordTcpReader(Logger logger, ReaderRegistry<String> stringRegistry) {
        this(10133, 65535, logger, stringRegistry, new CachedRecordFactoryCatalog());
    }

    public AbstractRecordTcpReader(int port, int bufferCapacity, Logger logger, ReaderRegistry<String> stringRegistry, CachedRecordFactoryCatalog recordFactories) {
        super(port, bufferCapacity, logger);
        this.stringRegistry = stringRegistry;
        this.recordFactories = recordFactories;
    }

    @Override
    protected final boolean onBufferReceived(ByteBuffer buffer) {
        if (buffer.remaining() < 4) {
            return false;
        }
        int clazzId = buffer.getInt();
        if (buffer.remaining() < 8) {
            return false;
        }
        long loggingTimestamp = buffer.getLong();
        String recordClassName = this.stringRegistry.get(clazzId);
        IRecordFactory<? extends IMonitoringRecord> recordFactory = this.recordFactories.get(recordClassName);
        if (buffer.remaining() < recordFactory.getRecordSizeInBytes()) {
            return false;
        }
        try {
            IMonitoringRecord record = recordFactory.create(BinaryValueDeserializer.create(buffer, this.stringRegistry));
            record.setLoggingTimestamp(loggingTimestamp);
            this.onRecordReceived(record);
        }
        catch (RecordInstantiationException ex) {
            this.logger.error("Failed to create: {}", (Object)recordClassName, (Object)ex);
        }
        return true;
    }

    protected abstract void onRecordReceived(IMonitoringRecord var1);
}

