/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.sink;

import java.io.File;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import kieker.model.system.model.ExecutionTrace;
import teetime.framework.AbstractConsumerStage;

public class EquivalenceClassWriter
extends AbstractConsumerStage<Map<ExecutionTrace, Integer>> {
    private static final String ENCODING = "UTF-8";
    private final File outputFile;

    public EquivalenceClassWriter(File outputFile) {
        this.outputFile = outputFile;
    }

    protected void onTerminating() {
        this.logger.debug("Terminatiing {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        super.onTerminating();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Map<ExecutionTrace, Integer> element) throws Exception {
        try (PrintStream ps = null;){
            ps = new PrintStream(Files.newOutputStream(this.outputFile.toPath(), new OpenOption[0]), false, ENCODING);
            int numClasses = 0;
            for (Map.Entry<ExecutionTrace, Integer> e : element.entrySet()) {
                ExecutionTrace t = e.getKey();
                ps.printf("Class %d; cardinality: %d; # executions: %d; representative: %d; max. stack depth: %d\n", numClasses++, e.getValue(), t.getLength(), t.getTraceId(), t.getMaxEss());
            }
            this.logger.debug("");
            this.logger.debug("#");
            this.logger.debug("# Plugin: Trace equivalence report");
            this.logger.debug("Wrote {} equivalence class{} to file '{}'", numClasses, numClasses > 1 ? "es" : "", this.outputFile.getCanonicalFile());
        }
    }
}

