/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.sink.display;

import kieker.analysis.display.TagCloud;
import kieker.analysis.display.annotation.Display;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.util.signature.ClassOperationSignaturePair;
import teetime.framework.AbstractConsumerStage;

public class MethodAndComponentFlowDisplaySink
extends AbstractConsumerStage<OperationExecutionRecord> {
    public static final String INPUT_PORT_NAME_EVENTS = "inputEvents";
    private final TagCloud methodTagCloud = new TagCloud();
    private final TagCloud componentTagCloud = new TagCloud();

    protected void execute(OperationExecutionRecord record) {
        String shortClassName = ClassOperationSignaturePair.splitOperationSignatureStr(record.getOperationSignature()).getSimpleClassname();
        String methodName = shortClassName + '.' + this.extractMethodName(record.getOperationSignature());
        this.methodTagCloud.incrementCounter(methodName);
        this.componentTagCloud.incrementCounter(shortClassName);
    }

    private String extractMethodName(String operationSignature) {
        String operationSignatureWithoutParameters = operationSignature.replaceAll("\\(.*\\)", "");
        int lastPointPos = operationSignatureWithoutParameters.lastIndexOf(46);
        return operationSignatureWithoutParameters.substring(lastPointPos + 1);
    }

    @Display(name="Method Tag Cloud Display")
    public TagCloud methodTagCloudDisplay() {
        return this.methodTagCloud;
    }

    @Display(name="Component Tag Cloud Display")
    public TagCloud componentTagCloudDisplay() {
        return this.componentTagCloud;
    }
}

