/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.source.tcp;

import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import kieker.common.record.io.BinaryValueDeserializer;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;

public class Connection {
    private final ReaderRegistry<String> registry = new ReaderRegistry();
    private final SocketChannel channel;
    private final ByteBuffer buffer;
    private final IValueDeserializer deserializer;
    private boolean error;

    public Connection(SocketChannel channel, int bufferSize) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        this.deserializer = BinaryValueDeserializer.create(this.buffer, this.registry);
        this.error = false;
    }

    public ReaderRegistry<String> getRegistry() {
        return this.registry;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public IValueDeserializer getValueDeserializer() {
        return this.deserializer;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isError() {
        return this.error;
    }
}

