/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.stage.events.delayfilter.components;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kieker.common.record.IMonitoringRecord;
import teetime.framework.AbstractProducerStage;

public class RealtimeRecordDelayProducer
extends AbstractProducerStage<IMonitoringRecord> {
    public static final double ACCELERATION_FACTOR_DEFAULT = 1.0;
    private final LinkedBlockingQueue<Object> recordQueue;
    private final Object endToken;
    private final TimeUnit timeunit;
    private final TimerWithPrecision timer;
    private final double accelerationFactor;
    private long negativeDelayWarningBound;
    private volatile long startTime = -1L;
    private volatile long firstLoggingTimestamp;

    public RealtimeRecordDelayProducer(LinkedBlockingQueue<Object> recordQueue, Object endToken, TimeUnit timeunit, double accelerationFactor) {
        TimerWithPrecision tmpTimer;
        this.recordQueue = recordQueue;
        this.endToken = endToken;
        this.timeunit = timeunit;
        try {
            tmpTimer = TimerWithPrecision.valueOf(this.timeunit.toString());
        }
        catch (IllegalArgumentException ex) {
            this.logger.warn(this.timeunit.toString() + " is no valid timer precision! Using MILLISECONDS instead.");
            tmpTimer = TimerWithPrecision.MILLISECONDS;
        }
        this.timer = tmpTimer;
        if (accelerationFactor <= 0.0) {
            this.logger.warn("Acceleration factor must be > 0. Using default: 1.0");
            this.accelerationFactor = 1.0;
        } else {
            this.accelerationFactor = accelerationFactor;
        }
        this.negativeDelayWarningBound = this.timeunit.convert(2L, TimeUnit.SECONDS);
    }

    protected void execute() {
        try {
            Object element = this.recordQueue.take();
            if (element == this.endToken) {
                this.terminateStage();
            } else if (element instanceof IMonitoringRecord) {
                long schedTimeFromNow;
                IMonitoringRecord monitoringRecord = (IMonitoringRecord)element;
                long currentTime = this.timer.getCurrentTime(this.timeunit);
                if (this.startTime == -1L) {
                    this.firstLoggingTimestamp = monitoringRecord.getLoggingTimestamp();
                    this.startTime = currentTime;
                }
                if ((schedTimeFromNow = (long)((double)(monitoringRecord.getLoggingTimestamp() - this.firstLoggingTimestamp) / this.accelerationFactor - (double)(currentTime - this.startTime))) < -this.negativeDelayWarningBound) {
                    long schedTimeSeconds = TimeUnit.SECONDS.convert(schedTimeFromNow, this.timeunit);
                    this.logger.warn("negative scheduling time: " + schedTimeFromNow + " (" + this.timeunit.toString() + ") / " + schedTimeSeconds + " (seconds)-> scheduling with a delay of 0");
                }
                if (schedTimeFromNow < 0L) {
                    schedTimeFromNow = 0L;
                }
                Thread.sleep(TimeUnit.MILLISECONDS.convert(schedTimeFromNow, this.timeunit));
                this.outputPort.send((Object)monitoringRecord);
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted while waiting for next record.");
        }
    }

    public long getNegativeDelayWarningBound() {
        return this.negativeDelayWarningBound;
    }

    public void setNegativeDelayWarningBound(long negativeDelay, TimeUnit unit) {
        this.negativeDelayWarningBound = this.timeunit.convert(negativeDelay, unit);
    }

    private static enum TimerWithPrecision {
        MILLISECONDS{

            @Override
            public long getCurrentTime(TimeUnit timeunit) {
                return timeunit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
        }
        ,
        NANOSECONDS{

            @Override
            public long getCurrentTime(TimeUnit timeunit) {
                return timeunit.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
            }
        };


        public abstract long getCurrentTime(TimeUnit var1);
    }
}

