/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.stage.flow;

import java.util.HashMap;
import java.util.Map;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.flow.thread.AfterFailedThreadBasedEvent;
import kieker.common.record.flow.thread.AfterThreadBasedEvent;
import kieker.common.record.flow.thread.BeforeThreadBasedEvent;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.misc.ThreadMetaData;
import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

public class ThreadEvent2TraceEventStage
extends AbstractConsumerStage<IMonitoringRecord> {
    private final OutputPort<IMonitoringRecord> outputPort = this.createOutputPort(IMonitoringRecord.class);
    private final Map<Long, String> hostNames = new HashMap<Long, String>();
    private final Map<Long, MonitoredTrace> monitoredTraces = new HashMap<Long, MonitoredTrace>();
    private int currentTraceId;

    protected void execute(IMonitoringRecord event) throws Exception {
        if (event instanceof BeforeThreadBasedEvent) {
            BeforeThreadBasedEvent originalEvent = (BeforeThreadBasedEvent)event;
            MonitoredTrace monitoredTrace = this.getOrCreateMonitoredThread(originalEvent.getLoggingTimestamp(), originalEvent.getThreadId());
            BeforeOperationEvent newEvent = new BeforeOperationEvent(originalEvent.getTimestamp(), monitoredTrace.identifier, originalEvent.getOrderIndex(), originalEvent.getOperationSignature(), originalEvent.getClassSignature());
            newEvent.setLoggingTimestamp(originalEvent.getLoggingTimestamp());
            this.outputPort.send((Object)newEvent);
        } else if (event instanceof AfterThreadBasedEvent) {
            AfterThreadBasedEvent originalEvent = (AfterThreadBasedEvent)event;
            MonitoredTrace monitoredTrace = this.getMonitoredThread(originalEvent.getThreadId());
            AfterOperationEvent newEvent = new AfterOperationEvent(originalEvent.getTimestamp(), monitoredTrace.identifier, originalEvent.getOrderIndex(), originalEvent.getOperationSignature(), originalEvent.getClassSignature());
            newEvent.setLoggingTimestamp(originalEvent.getLoggingTimestamp());
            this.outputPort.send((Object)newEvent);
        } else if (event instanceof AfterFailedThreadBasedEvent) {
            AfterFailedThreadBasedEvent originalEvent = (AfterFailedThreadBasedEvent)event;
            MonitoredTrace monitoredTrace = this.getMonitoredThread(originalEvent.getThreadId());
            AfterOperationFailedEvent newEvent = new AfterOperationFailedEvent(originalEvent.getTimestamp(), monitoredTrace.identifier, originalEvent.getOrderIndex(), originalEvent.getOperationSignature(), originalEvent.getClassSignature(), originalEvent.getCause());
            newEvent.setLoggingTimestamp(originalEvent.getLoggingTimestamp());
            this.outputPort.send((Object)newEvent);
        } else if (event instanceof ThreadMetaData) {
            ThreadMetaData threadMetaData = (ThreadMetaData)event;
            long threadId = threadMetaData.getThreadId();
            String hostName = threadMetaData.getHostname();
            this.hostNames.put(threadId, hostName);
        } else {
            this.outputPort.send((Object)event);
        }
    }

    private MonitoredTrace getOrCreateMonitoredThread(long beforeEventLoggingTimestamp, long threadId) {
        MonitoredTrace monitoredTrace;
        if (!this.monitoredTraces.containsKey(threadId)) {
            int uniqueTraceId = this.currentTraceId++;
            monitoredTrace = new MonitoredTrace(uniqueTraceId);
            monitoredTrace.currentStackSize = 0;
            this.monitoredTraces.put(threadId, monitoredTrace);
            long synthesizedLoggingTimestamp = beforeEventLoggingTimestamp - 1L;
            String hostName = this.hostNames.get(threadId);
            TraceMetadata traceMetadata = new TraceMetadata(monitoredTrace.identifier, threadId, "<NO SESSION>", hostName, -1L, -1);
            traceMetadata.setLoggingTimestamp(synthesizedLoggingTimestamp);
            this.outputPort.send((Object)traceMetadata);
        } else {
            monitoredTrace = this.monitoredTraces.get(threadId);
        }
        ++monitoredTrace.currentStackSize;
        return monitoredTrace;
    }

    private MonitoredTrace getMonitoredThread(long threadId) {
        MonitoredTrace monitoredTrace = this.monitoredTraces.get(threadId);
        --monitoredTrace.currentStackSize;
        if (monitoredTrace.currentStackSize == 0) {
            this.monitoredTraces.remove(threadId);
        }
        return monitoredTrace;
    }

    public OutputPort<IMonitoringRecord> getOutputPort() {
        return this.outputPort;
    }

    private static class MonitoredTrace {
        public final int identifier;
        public int currentStackSize;

        public MonitoredTrace(int identifier) {
            this.identifier = identifier;
        }
    }
}

