/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.stage.flow;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import kieker.analysis.stage.flow.TraceEventRecords;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.flow.trace.operation.AbstractOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import teetime.framework.AbstractStage;
import teetime.framework.InputPort;
import teetime.framework.OutputPort;

public class TraceAggregationFilter
extends AbstractStage {
    private final OutputPort<TraceEventRecords> tracesOutputPort = this.createOutputPort(TraceEventRecords.class);
    private final InputPort<TraceEventRecords> tracesInputPort = this.createInputPort();
    private final InputPort<Long> timestampInputPort = this.createInputPort(Long.class);
    private final TimeUnit timeunit;
    private final long maxCollectionDuration;
    private final Map<TraceEventRecords, TraceAggregationBuffer> trace2buffer;

    public TraceAggregationFilter(TimeUnit timeunit, long maxCollectionDuration) {
        this.timeunit = timeunit;
        this.maxCollectionDuration = this.timeunit.convert(maxCollectionDuration, timeunit);
        this.trace2buffer = new TreeMap<TraceEventRecords, TraceAggregationBuffer>(new TraceComperator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        TraceEventRecords traceEventRecords;
        Long timestamp = (Long)this.timestampInputPort.receive();
        if (timestamp != null) {
            TraceAggregationFilter traceAggregationFilter = this;
            synchronized (traceAggregationFilter) {
                this.processTimeoutQueue(timestamp);
            }
        }
        if ((traceEventRecords = (TraceEventRecords)this.tracesInputPort.receive()) != null) {
            this.newEvent(traceEventRecords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newEvent(TraceEventRecords traceEventRecords) {
        long timestamp = this.timeunit.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        TraceAggregationFilter traceAggregationFilter = this;
        synchronized (traceAggregationFilter) {
            TraceAggregationBuffer traceBuffer = this.trace2buffer.get(traceEventRecords);
            if (traceBuffer == null) {
                traceBuffer = new TraceAggregationBuffer(timestamp, traceEventRecords);
                this.trace2buffer.put(traceEventRecords, traceBuffer);
            }
            traceBuffer.count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTerminating() {
        TraceAggregationFilter traceAggregationFilter = this;
        synchronized (traceAggregationFilter) {
            for (Map.Entry<TraceEventRecords, TraceAggregationBuffer> entry : this.trace2buffer.entrySet()) {
                TraceAggregationBuffer buffer = entry.getValue();
                TraceEventRecords record = buffer.getTraceEventRecords();
                record.setCount(buffer.getCount());
                this.tracesOutputPort.send((Object)record);
            }
            this.trace2buffer.clear();
        }
        super.onTerminating();
    }

    private void processTimeoutQueue(long timestamp) {
        long bufferTimeout = timestamp - this.maxCollectionDuration;
        Iterator<Map.Entry<TraceEventRecords, TraceAggregationBuffer>> iterator = this.trace2buffer.entrySet().iterator();
        while (iterator.hasNext()) {
            TraceAggregationBuffer traceBuffer = iterator.next().getValue();
            if (traceBuffer.getBufferCreatedTimestamp() <= bufferTimeout) {
                TraceEventRecords record = traceBuffer.getTraceEventRecords();
                record.setCount(traceBuffer.getCount());
                this.tracesOutputPort.send((Object)record);
            }
            iterator.remove();
        }
    }

    private static final class TraceComperator
    implements Comparator<TraceEventRecords>,
    Serializable {
        private static final long serialVersionUID = 8920766818232517L;

        @Override
        public int compare(TraceEventRecords t1, TraceEventRecords t2) {
            AbstractTraceEvent[] recordsT2;
            AbstractTraceEvent[] recordsT1 = t1.getTraceEvents();
            if (recordsT1.length != (recordsT2 = t2.getTraceEvents()).length) {
                return recordsT1.length - recordsT2.length;
            }
            int cmpHostnames = t1.getTraceMetadata().getHostname().compareTo(t2.getTraceMetadata().getHostname());
            if (cmpHostnames != 0) {
                return cmpHostnames;
            }
            for (int i = 0; i < recordsT1.length; ++i) {
                int cmpError;
                int cmpSignature;
                AbstractTraceEvent recordT1 = recordsT1[i];
                AbstractTraceEvent recordT2 = recordsT2[i];
                int cmpClass = recordT1.getClass().getName().compareTo(recordT2.getClass().getName());
                if (cmpClass != 0) {
                    return cmpClass;
                }
                if (recordT1 instanceof AbstractOperationEvent && (cmpSignature = ((AbstractOperationEvent)recordT1).getOperationSignature().compareTo(((AbstractOperationEvent)recordT2).getOperationSignature())) != 0) {
                    return cmpSignature;
                }
                if (!(recordT1 instanceof AfterOperationFailedEvent) || (cmpError = ((AfterOperationFailedEvent)recordT1).getCause().compareTo(((AfterOperationFailedEvent)recordT2).getCause())) == 0) continue;
                return cmpClass;
            }
            return 0;
        }
    }

    private static final class TraceAggregationBuffer {
        private final long bufferCreatedTimestamp;
        private final TraceEventRecords aggregatedTrace;
        private int countOfAggregatedTraces;

        public TraceAggregationBuffer(long bufferCreatedTimestamp, TraceEventRecords trace) {
            this.bufferCreatedTimestamp = bufferCreatedTimestamp;
            this.aggregatedTrace = trace;
        }

        public void count() {
            ++this.countOfAggregatedTraces;
        }

        public long getBufferCreatedTimestamp() {
            return this.bufferCreatedTimestamp;
        }

        public TraceEventRecords getTraceEventRecords() {
            return this.aggregatedTrace;
        }

        public int getCount() {
            return this.countOfAggregatedTraces;
        }
    }
}

