/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.stage.model;

import kieker.analysis.stage.model.AbstractSourceModelAssembler;
import kieker.analysis.stage.model.IExecutionModelAssembler;
import kieker.analysis.stage.model.data.OperationCallDurationEvent;
import kieker.model.analysismodel.execution.AggregatedInvocation;
import kieker.model.analysismodel.execution.ExecutionFactory;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.sources.SourceModel;

public class ExecutionModelAssembler
extends AbstractSourceModelAssembler
implements IExecutionModelAssembler {
    private final ExecutionFactory factory = ExecutionFactory.eINSTANCE;
    private final ExecutionModel executionModel;

    public ExecutionModelAssembler(ExecutionModel executionModel, SourceModel sourceModel, String sourceLabel) {
        super(sourceModel, sourceLabel);
        this.executionModel = executionModel;
    }

    @Override
    public void addOperationCall(OperationCallDurationEvent operationCall) {
        if (!this.executionModel.getAggregatedInvocations().containsKey(operationCall.getOperationCall())) {
            AggregatedInvocation invocation = this.factory.createAggregatedInvocation();
            invocation.setSource(operationCall.getOperationCall().getFirst());
            invocation.setTarget(operationCall.getOperationCall().getSecond());
            this.updateSourceModel(invocation);
            this.executionModel.getAggregatedInvocations().put(operationCall.getOperationCall(), (Object)invocation);
        }
    }
}

