/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.statistics.calculating;

import java.util.Optional;
import java.util.function.Function;
import kieker.analysis.statistics.calculating.ICalculator;
import kieker.model.analysismodel.statistics.EPropertyType;
import kieker.model.analysismodel.statistics.StatisticRecord;
import org.eclipse.emf.ecore.EObject;

public class MinCalculator<T>
implements ICalculator<T> {
    private final Function<T, Long> valueAccessor;

    public MinCalculator(Function<T, Long> valueAccessor) {
        this.valueAccessor = valueAccessor;
    }

    @Override
    public void calculate(StatisticRecord statistic, T input, EObject modelObject) {
        long value = this.valueAccessor.apply(input);
        Optional<Long> oldMin = Optional.ofNullable((Long)statistic.getProperties().get((Object)EPropertyType.MIN));
        if (!oldMin.isPresent() || value < oldMin.get()) {
            statistic.getProperties().put((Object)EPropertyType.MIN, (Object)value);
        }
    }
}

