/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.trace;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kieker.model.system.model.AbstractSession;
import kieker.model.system.model.ExecutionTrace;
import kieker.model.system.model.ExecutionTraceBasedSession;
import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

public class SessionReconstructionFilter
extends AbstractConsumerStage<ExecutionTrace> {
    private static final int DEFAULT_QUEUE_SIZE = 16;
    private final OutputPort<ExecutionTraceBasedSession> outputPort = this.createOutputPort(ExecutionTraceBasedSession.class);
    private final long maxThinkTime;
    private final ConcurrentHashMap<String, ExecutionTraceBasedSession> openExecutionBasedSessions = new ConcurrentHashMap();
    private final PriorityQueue<ExecutionTraceBasedSession> executionSessionTimeoutQueue = new PriorityQueue(16, new SessionEndTimestampComparator());

    public SessionReconstructionFilter(TimeUnit timeunit, Long maxThinkTime) {
        this.maxThinkTime = timeunit.convert(maxThinkTime == 0L ? Long.MAX_VALUE : maxThinkTime, timeunit);
        if (this.maxThinkTime < 0L) {
            throw new IllegalArgumentException("maxThinkTime must not be negative (found: " + this.maxThinkTime + ")");
        }
    }

    public OutputPort<ExecutionTraceBasedSession> getOutputPort() {
        return this.outputPort;
    }

    private void dispatchCompletedSession(ExecutionTraceBasedSession session) {
        session.setCompleted();
        this.outputPort.send((Object)session);
    }

    private void processTimeouts(long currentTime, PriorityQueue<ExecutionTraceBasedSession> timeoutQueue, Map<String, ExecutionTraceBasedSession> openSessions) {
        ExecutionTraceBasedSession session;
        long currentThinkTime;
        while (!timeoutQueue.isEmpty() && (currentThinkTime = currentTime - (session = timeoutQueue.peek()).getEndTimestamp()) > this.maxThinkTime) {
            timeoutQueue.remove();
            openSessions.remove(session.getSessionId());
            this.dispatchCompletedSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndDispatchAllSessions(PriorityQueue<ExecutionTraceBasedSession> timeoutQueue, Map<String, ExecutionTraceBasedSession> openSessions) {
        SessionReconstructionFilter sessionReconstructionFilter = this;
        synchronized (sessionReconstructionFilter) {
            while (!timeoutQueue.isEmpty()) {
                ExecutionTraceBasedSession session = timeoutQueue.poll();
                openSessions.remove(session.getSessionId());
                this.dispatchCompletedSession(session);
            }
        }
    }

    private void closeAndDispatchRemainingSessions() {
        this.closeAndDispatchAllSessions(this.executionSessionTimeoutQueue, this.openExecutionBasedSessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(ExecutionTrace executionTrace) throws Exception {
        SessionReconstructionFilter sessionReconstructionFilter = this;
        synchronized (sessionReconstructionFilter) {
            long currentTimestamp = executionTrace.getStartTimestamp();
            this.processTimeouts(currentTimestamp, this.executionSessionTimeoutQueue, this.openExecutionBasedSessions);
            boolean existingSession = true;
            String sessionId = executionTrace.getSessionId();
            ExecutionTraceBasedSession session = this.openExecutionBasedSessions.get(sessionId);
            if (session == null) {
                session = new ExecutionTraceBasedSession(sessionId);
                ExecutionTraceBasedSession previousSession = this.openExecutionBasedSessions.putIfAbsent(sessionId, session);
                existingSession = previousSession != null;
            }
            session.addTrace(executionTrace);
            if (existingSession) {
                this.executionSessionTimeoutQueue.remove(session);
            }
            this.executionSessionTimeoutQueue.add(session);
        }
    }

    public void onTerminating() {
        this.closeAndDispatchRemainingSessions();
        super.onTerminating();
    }

    private static class SessionEndTimestampComparator
    implements Comparator<AbstractSession<?>>,
    Serializable {
        private static final long serialVersionUID = -5631887288009598075L;

        @Override
        public int compare(AbstractSession<?> o1, AbstractSession<?> o2) {
            long endTimestamp2;
            long endTimestamp1 = o1.getEndTimestamp();
            if (endTimestamp1 == (endTimestamp2 = o2.getEndTimestamp())) {
                return 0;
            }
            if (endTimestamp1 < endTimestamp2) {
                return -1;
            }
            return 1;
        }
    }
}

