/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.trace.reconstruction;

import kieker.analysis.trace.traversal.IOperationCallVisitor;
import kieker.model.analysismodel.trace.OperationCall;

public class DurRatioToRootParentCalculator
implements IOperationCallVisitor {
    private final OperationCall rootOperationCall;

    public DurRatioToRootParentCalculator(OperationCall rootOperationCall) {
        this.rootOperationCall = rootOperationCall;
    }

    @Override
    public void visit(OperationCall operationCall) {
        if (operationCall.getParent() == null) {
            operationCall.setDurRatioToParent(100.0f);
        } else {
            long childDuration = operationCall.getDuration().toNanos();
            long rootDuration = this.rootOperationCall.getDuration().toNanos();
            float ratio = 100.0f * (float)childDuration / (float)rootDuration;
            operationCall.setDurRatioToParent(ratio);
        }
    }
}

