/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.tt.reader.filesystem.format.binary.file;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import kieker.analysis.plugin.reader.depcompression.AbstractDecompressionFilter;
import kieker.analysis.plugin.reader.util.FSReaderUtil;
import kieker.analysis.tt.reader.filesystem.className.ClassNameRegistryRepository;
import kieker.analysis.tt.reader.filesystem.format.binary.file.RecordFromBinaryFileCreator;
import kieker.common.configuration.Configuration;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.record.IMonitoringRecord;
import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

@Deprecated
public class BinaryFile2RecordFilter
extends AbstractConsumerStage<File> {
    private final OutputPort<IMonitoringRecord> outputPort = this.createOutputPort();
    private RecordFromBinaryFileCreator recordFromBinaryFileCreator;
    private ClassNameRegistryRepository classNameRegistryRepository;

    public BinaryFile2RecordFilter(ClassNameRegistryRepository classNameRegistryRepository) {
        this();
        this.classNameRegistryRepository = classNameRegistryRepository;
    }

    public BinaryFile2RecordFilter() {
    }

    public void onStarting() {
        super.onStarting();
        this.recordFromBinaryFileCreator = new RecordFromBinaryFileCreator(this.classNameRegistryRepository);
    }

    public ClassNameRegistryRepository getClassNameRegistryRepository() {
        return this.classNameRegistryRepository;
    }

    public void setClassNameRegistryRepository(ClassNameRegistryRepository classNameRegistryRepository) {
        this.classNameRegistryRepository = classNameRegistryRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(File binaryFile) {
        String name = binaryFile.getName();
        Class<? extends AbstractDecompressionFilter> clazz = FSReaderUtil.findDecompressionFilterByExtension(name);
        try {
            AbstractDecompressionFilter filter = clazz.getConstructor(Configuration.class).newInstance(new Configuration());
            DataInputStream inputStream = new DataInputStream(filter.chainInputStream(Files.newInputStream(binaryFile.toPath(), StandardOpenOption.READ)));
            try {
                this.recordFromBinaryFileCreator.createRecordsFromBinaryFile(binaryFile, inputStream, this.outputPort);
            }
            catch (MonitoringRecordException e) {
                this.logger.error("Error reading file: " + binaryFile, e);
            }
            finally {
                if (inputStream != null) {
                    this.closeStream(inputStream);
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Error reading file: " + binaryFile, e);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Unknown file extension for file: " + binaryFile);
        }
        catch (InstantiationException e1) {
            this.logger.error("Decompression filter instantiation failed. {}", e1);
        }
        catch (IllegalAccessException e1) {
            this.logger.error("Decompression filter instantiation failed. {}", e1);
        }
        catch (InvocationTargetException e1) {
            this.logger.error("Decompression filter instantiation failed. {}", e1);
        }
        catch (NoSuchMethodException e1) {
            this.logger.error("Decompression filter instantiation failed. {}", e1);
        }
        catch (SecurityException e1) {
            this.logger.error("Decompression filter instantiation failed. {}", e1);
        }
    }

    private void closeStream(DataInputStream dataInputStream) {
        try {
            dataInputStream.close();
        }
        catch (IOException ex) {
            this.logger.error("Exception while closing input stream for processing input file", ex);
        }
    }

    public OutputPort<IMonitoringRecord> getOutputPort() {
        return this.outputPort;
    }
}

