/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.tt.reader.filesystem.fsReader;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import kieker.analysis.plugin.reader.util.IMonitoringRecordReceiver;
import kieker.analysis.tt.reader.filesystem.fsReader.AbstractLogReaderThread;
import kieker.analysis.tt.reader.filesystem.fsReader.BinaryLogReaderThread;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.EmptyRecord;
import teetime.framework.AbstractProducerStage;

@Deprecated
public class BinaryLogReader
extends AbstractProducerStage<IMonitoringRecord>
implements IMonitoringRecordReceiver {
    private static final IMonitoringRecord EOF = new EmptyRecord();
    private final String[] inputDirs;
    private final PriorityQueue<IMonitoringRecord> recordQueue;
    private final boolean shouldDecompress;
    private final List<AbstractLogReaderThread> readerThreads = new ArrayList<AbstractLogReaderThread>();

    public BinaryLogReader(String[] inputDirs, boolean shouldDecompress) {
        this.inputDirs = (String[])inputDirs.clone();
        int nDirs = this.inputDirs.length;
        for (int i = 0; i < nDirs; ++i) {
            if (".".equals(this.inputDirs[i])) continue;
            this.inputDirs[i] = Configuration.convertToPath(this.inputDirs[i]);
        }
        if (nDirs == 0) {
            this.logger.warn("The list of input dirs passed to the " + BinaryLogReader.class.getSimpleName() + " is empty");
            nDirs = 1;
        }
        this.recordQueue = new PriorityQueue(nDirs);
        this.shouldDecompress = shouldDecompress;
    }

    public void terminateStage() {
        this.logger.info("Shutting down reader.");
        for (AbstractLogReaderThread readerThread : this.readerThreads) {
            readerThread.terminate();
        }
        super.terminateStage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        int notInitializesReaders = 0;
        for (String inputDirFn : this.inputDirs) {
            File inputDir = new File(inputDirFn);
            if (inputDir.isDirectory()) {
                BinaryLogReaderThread readerThread = new BinaryLogReaderThread(inputDir, this, this.shouldDecompress);
                readerThread.setDaemon(true);
                this.readerThreads.add(readerThread);
                readerThread.start();
                continue;
            }
            this.logger.warn("Invalid Directory or filename (no Kieker log): " + inputDirFn);
            ++notInitializesReaders;
        }
        int readingReaders = this.inputDirs.length - notInitializesReaders;
        while (readingReaders > 0) {
            IMonitoringRecord record;
            PriorityQueue<IMonitoringRecord> priorityQueue = this.recordQueue;
            synchronized (priorityQueue) {
                while (this.recordQueue.size() < readingReaders) {
                    try {
                        this.recordQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            IMonitoringRecord iMonitoringRecord = record = (IMonitoringRecord)this.recordQueue.remove();
            synchronized (iMonitoringRecord) {
                record.notifyAll();
            }
            if (record == EOF) {
                --readingReaders;
                continue;
            }
            this.outputPort.send((Object)record);
        }
        this.terminateStage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean newMonitoringRecord(IMonitoringRecord record) {
        IMonitoringRecord iMonitoringRecord = record;
        synchronized (iMonitoringRecord) {
            PriorityQueue<IMonitoringRecord> priorityQueue = this.recordQueue;
            synchronized (priorityQueue) {
                this.recordQueue.add(record);
                this.recordQueue.notifyAll();
            }
            try {
                record.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public void newEndOfFileRecord() {
        this.newMonitoringRecord(EOF);
    }
}

