/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.tt.reader.filesystem.fsReader;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Comparator;
import kieker.analysis.plugin.reader.depcompression.AbstractDecompressionFilter;
import kieker.analysis.plugin.reader.filesystem.BinaryFileStreamProcessor;
import kieker.analysis.plugin.reader.filesystem.TextFileStreamProcessor;
import kieker.analysis.plugin.reader.util.FSReaderUtil;
import kieker.analysis.plugin.reader.util.IMonitoringRecordReceiver;
import kieker.common.configuration.Configuration;
import kieker.common.registry.reader.ReaderRegistry;
import kieker.common.util.classpath.InstantiationFactory;
import kieker.common.util.filesystem.FSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FSDirectoryReader
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FSDirectoryReader.class);
    String filePrefix = "kieker";
    private final ReaderRegistry<String> stringRegistry = new ReaderRegistry();
    private final IMonitoringRecordReceiver recordReceiver;
    private final File inputDir;
    private boolean terminated;
    private final boolean ignoreUnknownRecordTypes;
    private final TextFileStreamProcessor textFileStreamProcessor;
    private final BinaryFileStreamProcessor binaryFileStreamProcessor;

    public FSDirectoryReader(File inputDir, IMonitoringRecordReceiver recordReceiver, boolean ignoreUnknownRecordTypes) {
        if (inputDir == null || !inputDir.isDirectory()) {
            throw new IllegalArgumentException("Invalid or empty inputDir");
        }
        this.inputDir = inputDir;
        this.recordReceiver = recordReceiver;
        this.ignoreUnknownRecordTypes = ignoreUnknownRecordTypes;
        this.textFileStreamProcessor = new TextFileStreamProcessor(ignoreUnknownRecordTypes, this.stringRegistry, recordReceiver);
        this.binaryFileStreamProcessor = new BinaryFileStreamProcessor(this.stringRegistry, recordReceiver);
    }

    @Override
    public final void run() {
        this.readMappingFile();
        File[] inputFiles = this.inputDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                return pathname.isFile() && name.startsWith(FSDirectoryReader.this.filePrefix) && FSReaderUtil.hasValidFileExtension(name);
            }
        });
        if (inputFiles == null) {
            LOGGER.error("Directory '{}' does not exist or an I/O error occured.", (Object)this.inputDir);
        } else if (inputFiles.length == 0) {
            LOGGER.warn("Directory '{}' contains no files starting with '{}' and ending with a valid file extension.", (Object)this.inputDir, (Object)this.filePrefix);
        } else {
            Arrays.sort(inputFiles, new Comparator<File>(){

                @Override
                public final int compare(File f1, File f2) {
                    return f1.compareTo(f2);
                }
            });
            boolean ignoreUnknownRecordTypesWarningAlreadyShown = false;
            for (File inputFile : inputFiles) {
                if (this.terminated) {
                    LOGGER.info("Shutting down DirectoryReader.");
                    break;
                }
                LOGGER.info("< Loading {}", (Object)inputFile.getAbsolutePath());
                if (inputFile.getName().endsWith(".dat")) {
                    this.processNormalInputFile(inputFile);
                    continue;
                }
                if (this.ignoreUnknownRecordTypes && ignoreUnknownRecordTypesWarningAlreadyShown) {
                    ignoreUnknownRecordTypesWarningAlreadyShown = true;
                    LOGGER.warn("The property '{}' is not supported for binary files. But trying to read '{}'", (Object)"ignoreUnknownRecordTypes", (Object)inputFile);
                }
                try {
                    Class<? extends AbstractDecompressionFilter> clazz = FSReaderUtil.findDecompressionFilterByExtension(inputFile.getName());
                    Configuration configuration = new Configuration();
                    AbstractDecompressionFilter decompressionFilter = InstantiationFactory.getInstance(configuration).createAndInitialize(AbstractDecompressionFilter.class, clazz.getCanonicalName(), configuration);
                    this.processBinaryInputFile(inputFile, decompressionFilter);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Unknown file extension for file {}", (Object)inputFile);
                }
            }
        }
        this.recordReceiver.newEndOfFileRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readMappingFile() {
        File mappingFile = new File(this.inputDir.getAbsolutePath() + File.separator + "kieker.map");
        if (!mappingFile.exists()) {
            mappingFile = new File(this.inputDir.getAbsolutePath() + File.separator + "tpmon.map");
            if (mappingFile.exists()) {
                LOGGER.info("Directory '{}' contains no file '{}'. Found '{}' ... switching to legacy mode", this.inputDir, "kieker.map", "tpmon.map");
                this.filePrefix = "tpmon";
            } else {
                LOGGER.warn("No mapping file in directory '{}'", (Object)this.inputDir.getAbsolutePath());
                return;
            }
        }
        BufferedReader in = null;
        try {
            String line;
            in = Files.newBufferedReader(mappingFile.toPath(), Charset.forName("UTF-8"));
            while ((line = in.readLine()) != null) {
                Integer id;
                if (line.length() == 0) continue;
                LOGGER.debug("Read line: {}", (Object)line);
                int split = line.indexOf(61);
                if (split == -1) {
                    LOGGER.error("Failed to parse line: {} from file {}. Each line must contain ID=VALUE pairs.", (Object)line, (Object)mappingFile.getAbsolutePath());
                    continue;
                }
                String key = line.substring(0, split);
                String value = FSUtil.decodeNewline(line.substring(split + 1));
                try {
                    id = Integer.valueOf(key.charAt(0) == '$' ? key.substring(1) : key);
                }
                catch (NumberFormatException ex) {
                    LOGGER.error("Error reading mapping file, id must be integer", ex);
                    continue;
                }
                String prevVal = this.stringRegistry.register(id.intValue(), value);
                if (prevVal == null) continue;
                LOGGER.error("Found addional entry for id='{}', old value was '{}' new value is '{}'", id, prevVal, value);
            }
        }
        catch (IOException ex) {
            LOGGER.error("Error reading mapping file", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOGGER.error("Exception while closing input stream for mapping file", ex);
                }
            }
        }
    }

    private final void processNormalInputFile(File inputFile) {
        try {
            this.textFileStreamProcessor.processInputChannel(Files.newInputStream(inputFile.toPath(), StandardOpenOption.READ));
            this.terminated = true;
        }
        catch (Exception ex) {
            LOGGER.error("Error reading {}", (Object)inputFile, (Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processBinaryInputFile(File inputFile, AbstractDecompressionFilter decompressionFilter) {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(decompressionFilter.chainInputStream(Files.newInputStream(inputFile.toPath(), StandardOpenOption.READ)));
            this.binaryFileStreamProcessor.createRecordsFromBinaryFile((DataInputStream)in);
        }
        catch (Exception ex) {
            LOGGER.error("Error reading {}", (Object)inputFile, (Object)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOGGER.error("Exception while closing input stream for processing input file", ex);
                }
            }
        }
    }
}

