/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.tt.reader.filesystem.fsReader;

import java.io.File;
import java.util.PriorityQueue;
import kieker.analysis.plugin.reader.filesystem.FSZipReader;
import kieker.analysis.plugin.reader.util.IMonitoringRecordReceiver;
import kieker.analysis.tt.reader.filesystem.fsReader.FSDirectoryReader;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.EmptyRecord;
import teetime.framework.AbstractProducerStage;

@Deprecated
public class FSReader
extends AbstractProducerStage<IMonitoringRecord>
implements IMonitoringRecordReceiver {
    private static final IMonitoringRecord EOF = new EmptyRecord();
    private final boolean ignoreUnknownRecordTypes;
    private final String[] inputDirs;
    private final PriorityQueue<IMonitoringRecord> recordQueue;
    private volatile boolean running = true;

    public FSReader(String[] inputDirs, boolean ignoreUnknownRecordTypes) {
        this.inputDirs = (String[])inputDirs.clone();
        int nDirs = this.inputDirs.length;
        for (int i = 0; i < nDirs; ++i) {
            if (".".equals(this.inputDirs[i])) continue;
            this.inputDirs[i] = Configuration.convertToPath(this.inputDirs[i]);
        }
        if (nDirs == 0) {
            this.logger.warn("The list of input dirs passed to the {} is empty", (Object)FSReader.class.getSimpleName());
            nDirs = 1;
        }
        this.recordQueue = new PriorityQueue(nDirs);
        this.ignoreUnknownRecordTypes = ignoreUnknownRecordTypes;
    }

    public void terminateStage() {
        this.logger.info("Shutting down reader.");
        this.running = false;
        super.terminateStage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        int notInitializesReaders = 0;
        for (String inputDirFn : this.inputDirs) {
            Thread readerThread;
            File inputDir = new File(inputDirFn);
            if (inputDir.isDirectory()) {
                readerThread = new Thread(new FSDirectoryReader(inputDir, this, this.ignoreUnknownRecordTypes));
            } else if (inputDir.isFile() && inputDirFn.endsWith(".zip")) {
                readerThread = new Thread(new FSZipReader(inputDir, this, this.ignoreUnknownRecordTypes));
            } else {
                this.logger.warn("Invalid Directory or filename (no Kieker log): {}", (Object)inputDirFn);
                ++notInitializesReaders;
                continue;
            }
            readerThread.setDaemon(true);
            readerThread.start();
        }
        int readingReaders = this.inputDirs.length - notInitializesReaders;
        while (readingReaders > 0) {
            IMonitoringRecord record;
            PriorityQueue<IMonitoringRecord> priorityQueue = this.recordQueue;
            synchronized (priorityQueue) {
                while (this.recordQueue.size() < readingReaders) {
                    try {
                        this.recordQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            IMonitoringRecord iMonitoringRecord = record = (IMonitoringRecord)this.recordQueue.remove();
            synchronized (iMonitoringRecord) {
                record.notifyAll();
            }
            if (record == EOF) {
                --readingReaders;
                continue;
            }
            this.outputPort.send((Object)record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean newMonitoringRecord(IMonitoringRecord record) {
        IMonitoringRecord iMonitoringRecord = record;
        synchronized (iMonitoringRecord) {
            PriorityQueue<IMonitoringRecord> priorityQueue = this.recordQueue;
            synchronized (priorityQueue) {
                this.recordQueue.add(record);
                this.recordQueue.notifyAll();
            }
            try {
                record.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.running;
    }

    @Override
    public void newEndOfFileRecord() {
        this.newMonitoringRecord(EOF);
    }

    public boolean isIgnoreUnknownRecordTypes() {
        return this.ignoreUnknownRecordTypes;
    }
}

