/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.namedRecordPipe;

import kieker.common.namedRecordPipe.IPipeReader;
import kieker.common.record.IMonitoringRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Pipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pipe.class);
    private final String name;
    private volatile IPipeReader pipeReader;
    private volatile boolean closed;

    public Pipe(String name) {
        this.name = name;
    }

    public void setPipeReader(IPipeReader pipeReader) {
        this.pipeReader = pipeReader;
        LOGGER.debug("PipeReader initialized");
    }

    public String getName() {
        return this.name;
    }

    public boolean writeMonitoringRecord(IMonitoringRecord monitoringRecord) {
        if (this.closed) {
            LOGGER.error("trying to write to closed pipe");
            return false;
        }
        if (this.pipeReader == null) {
            LOGGER.error("pipeReader is null, i.e., no pipe reader has been registered.");
            return false;
        }
        return this.pipeReader.newMonitoringRecord(monitoringRecord);
    }

    public void close() {
        this.closed = true;
        if (this.pipeReader != null) {
            this.pipeReader.notifyPipeClosed();
        }
    }
}

