/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.controlflow;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class OperationExecutionRecord
extends AbstractMonitoringRecord {
    public static final int SIZE = 44;
    public static final Class<?>[] TYPES = new Class[]{String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, String.class, Integer.TYPE, Integer.TYPE};
    public static final String NO_HOSTNAME = "<default-host>";
    public static final String NO_SESSION_ID = "<no-session-id>";
    public static final String NO_OPERATION_SIGNATURE = "noOperation";
    public static final long NO_TRACE_ID = -1L;
    public static final long NO_TIMESTAMP = -1L;
    public static final int NO_EOI_ESS = -1;
    public static final String[] VALUE_NAMES = new String[]{"operationSignature", "sessionId", "traceId", "tin", "tout", "hostname", "eoi", "ess"};
    public static final String OPERATION_SIGNATURE = "noOperation";
    public static final String SESSION_ID = "<no-session-id>";
    public static final long TRACE_ID = -1L;
    public static final long TIN = -1L;
    public static final long TOUT = -1L;
    public static final String HOSTNAME = "<default-host>";
    public static final int EOI = -1;
    public static final int ESS = -1;
    private static final long serialVersionUID = -7768272829642950711L;
    private final String operationSignature;
    private final String sessionId;
    private final long traceId;
    private final long tin;
    private final long tout;
    private final String hostname;
    private final int eoi;
    private final int ess;

    public OperationExecutionRecord(String operationSignature, String sessionId, long traceId, long tin, long tout, String hostname, int eoi, int ess) {
        this.operationSignature = operationSignature == null ? "noOperation" : operationSignature;
        this.sessionId = sessionId == null ? "<no-session-id>" : sessionId;
        this.traceId = traceId;
        this.tin = tin;
        this.tout = tout;
        this.hostname = hostname == null ? "<default-host>" : hostname;
        this.eoi = eoi;
        this.ess = ess;
    }

    public OperationExecutionRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.operationSignature = deserializer.getString();
        this.sessionId = deserializer.getString();
        this.traceId = deserializer.getLong();
        this.tin = deserializer.getLong();
        this.tout = deserializer.getLong();
        this.hostname = deserializer.getString();
        this.eoi = deserializer.getInt();
        this.ess = deserializer.getInt();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putString(this.getOperationSignature());
        serializer.putString(this.getSessionId());
        serializer.putLong(this.getTraceId());
        serializer.putLong(this.getTin());
        serializer.putLong(this.getTout());
        serializer.putString(this.getHostname());
        serializer.putInt(this.getEoi());
        serializer.putInt(this.getEss());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 44;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        OperationExecutionRecord castedRecord = (OperationExecutionRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        if (!this.getSessionId().equals(castedRecord.getSessionId())) {
            return false;
        }
        if (this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        if (this.getTin() != castedRecord.getTin()) {
            return false;
        }
        if (this.getTout() != castedRecord.getTout()) {
            return false;
        }
        if (!this.getHostname().equals(castedRecord.getHostname())) {
            return false;
        }
        if (this.getEoi() != castedRecord.getEoi()) {
            return false;
        }
        return this.getEss() == castedRecord.getEss();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += this.getOperationSignature().hashCode();
        code += this.getSessionId().hashCode();
        code += (int)this.getTraceId();
        code += (int)this.getTin();
        code += (int)this.getTout();
        code += this.getHostname().hashCode();
        code += this.getEoi();
        return code += this.getEss();
    }

    public final String getOperationSignature() {
        return this.operationSignature;
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final long getTraceId() {
        return this.traceId;
    }

    public final long getTin() {
        return this.tin;
    }

    public final long getTout() {
        return this.tout;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final int getEoi() {
        return this.eoi;
    }

    public final int getEss() {
        return this.ess;
    }

    @Override
    public String toString() {
        String result = "OperationExecutionRecord: ";
        result = result + "operationSignature = ";
        result = result + this.getOperationSignature() + ", ";
        result = result + "sessionId = ";
        result = result + this.getSessionId() + ", ";
        result = result + "traceId = ";
        result = result + this.getTraceId() + ", ";
        result = result + "tin = ";
        result = result + this.getTin() + ", ";
        result = result + "tout = ";
        result = result + this.getTout() + ", ";
        result = result + "hostname = ";
        result = result + this.getHostname() + ", ";
        result = result + "eoi = ";
        result = result + this.getEoi() + ", ";
        result = result + "ess = ";
        result = result + this.getEss() + ", ";
        return result;
    }
}

