/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.factory;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.factory.RecordFactoryResolver;

public final class CachedRecordFactoryCatalog {
    private static final CachedRecordFactoryCatalog INSTANCE = new CachedRecordFactoryCatalog(new RecordFactoryResolver());
    private final ConcurrentMap<String, IRecordFactory<? extends IMonitoringRecord>> cachedRecordFactories = new ConcurrentHashMap<String, IRecordFactory<? extends IMonitoringRecord>>();
    private final RecordFactoryResolver recordFactoryResolver;

    public CachedRecordFactoryCatalog() {
        this(new RecordFactoryResolver());
    }

    CachedRecordFactoryCatalog(RecordFactoryResolver recordFactoryResolver) {
        this.recordFactoryResolver = recordFactoryResolver;
    }

    public static CachedRecordFactoryCatalog getInstance() {
        return INSTANCE;
    }

    public IRecordFactory<? extends IMonitoringRecord> get(String recordClassName) {
        IRecordFactory<? extends IMonitoringRecord> existingFactory;
        IRecordFactory<? extends IMonitoringRecord> recordFactory = (IRecordFactory<? extends IMonitoringRecord>)this.cachedRecordFactories.get(recordClassName);
        if (recordFactory == null && (recordFactory = this.recordFactoryResolver.get(recordClassName)) != null && (existingFactory = this.cachedRecordFactories.putIfAbsent(recordClassName, recordFactory)) != null) {
            recordFactory = existingFactory;
        }
        return recordFactory;
    }
}

