/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation.constructor;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.IConstructorRecord;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class BeforeConstructorEvent
extends BeforeOperationEvent
implements IConstructorRecord {
    public static final int SIZE = 28;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "traceId", "orderIndex", "operationSignature", "classSignature"};
    private static final long serialVersionUID = -7724172518672268698L;

    public BeforeConstructorEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature) {
        super(timestamp, traceId, orderIndex, operationSignature, classSignature);
    }

    public BeforeConstructorEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getOperationSignature());
        serializer.putString(this.getClassSignature());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 28;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BeforeConstructorEvent castedRecord = (BeforeConstructorEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        if (this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        return this.getClassSignature().equals(castedRecord.getClassSignature());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        code += this.getOperationSignature().hashCode();
        return code += this.getClassSignature().hashCode();
    }

    @Override
    public String toString() {
        String result = "BeforeConstructorEvent: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "traceId = ";
        result = result + this.getTraceId() + ", ";
        result = result + "orderIndex = ";
        result = result + this.getOrderIndex() + ", ";
        result = result + "operationSignature = ";
        result = result + this.getOperationSignature() + ", ";
        result = result + "classSignature = ";
        result = result + this.getClassSignature() + ", ";
        return result;
    }
}

