/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.misc;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class TimestampRecord
extends AbstractMonitoringRecord {
    public static final int SIZE = 8;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp"};
    public static final long TIMESTAMP = 0L;
    private static final long serialVersionUID = -6797766837645151845L;
    private final long timestamp;

    public TimestampRecord(long timestamp) {
        this.timestamp = timestamp;
    }

    public TimestampRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 8;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TimestampRecord castedRecord = (TimestampRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        return this.getTimestamp() == castedRecord.getTimestamp();
    }

    @Override
    public int hashCode() {
        int code = 0;
        return code += (int)this.getTimestamp();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String toString() {
        String result = "TimestampRecord: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        return result;
    }
}

