/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.util.classpath;

import java.lang.reflect.InvocationTargetException;
import kieker.common.configuration.Configuration;
import kieker.common.exception.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstantiationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstantiationFactory.class);
    private static final InstantiationFactory INSTANCE = new InstantiationFactory();

    private InstantiationFactory() {
    }

    public static InstantiationFactory getInstance(Configuration configuration) {
        return INSTANCE;
    }

    public <C> C createAndInitialize(Class<C> c, String className, Configuration configuration) {
        C createdClass = null;
        try {
            Class<?> clazz = Class.forName(className);
            if (c.isAssignableFrom(clazz)) {
                createdClass = (C)clazz.getConstructor(Configuration.class).newInstance(configuration.flatten());
            } else {
                LOGGER.error("Class '{}' has to implement '{}'", (Object)className, (Object)c.getSimpleName());
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("{}: Class '{}' not found", c.getSimpleName(), className, e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("{}: Class '{}' has to implement a (public) constructor that accepts a single Configuration", c.getSimpleName(), className, e);
        }
        catch (Exception e) {
            LOGGER.error("{}: Failed to load class for name '{}'", c.getSimpleName(), className, e);
        }
        return createdClass;
    }

    public static <C> C createWithConfiguration(Class<C> implementedInterface, String className, Configuration configuration) throws ConfigurationException {
        try {
            Class<?> clazz = Class.forName(className);
            if (implementedInterface.isAssignableFrom(clazz)) {
                Class[] parameterTypes = new Class[]{Configuration.class};
                return InstantiationFactory.instantiateClass(implementedInterface, clazz, parameterTypes, configuration);
            }
            LOGGER.error("Class '{}' has to implement '{}'.", (Object)className, (Object)implementedInterface.getSimpleName());
            throw new ConfigurationException("Requested class does not match interface.");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("{}: Class '{}' not found: {}", implementedInterface.getSimpleName(), className, e.getLocalizedMessage());
            throw new ConfigurationException(e);
        }
    }

    public <C> C create(Class<C> c, String className, Class<?>[] parameterTypes, Object ... parameters) {
        C createdClass = null;
        try {
            Class<?> clazz = Class.forName(className);
            if (c.isAssignableFrom(clazz)) {
                createdClass = (C)clazz.getConstructor(parameterTypes).newInstance(parameters);
            } else {
                LOGGER.error("Class '{}' has to implement '{}'", (Object)className, (Object)c.getSimpleName());
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("{}: Class '{}' not found", c.getSimpleName(), className, e);
        }
        catch (NoSuchMethodException e) {
            StringBuilder parameterTypeNames = new StringBuilder();
            for (Object parameter : parameters) {
                parameterTypeNames.append(", ");
                parameterTypeNames.append(parameter.getClass().getName());
            }
            LOGGER.error("{}: Class '{}' has to implement a (public) constructor that accepts {}", c.getSimpleName(), className, parameterTypeNames.toString(), e);
        }
        catch (Exception e) {
            LOGGER.error("{}: Failed to load class for name '{}'", c.getSimpleName(), className, e);
        }
        return createdClass;
    }

    private static <C> C instantiateClass(Class<C> implementedInterface, Class<?> clazz, Class<?>[] parameterTypes, Object ... parameters) throws ConfigurationException {
        try {
            return (C)clazz.getConstructor(parameterTypes).newInstance(parameters);
        }
        catch (InstantiationException e) {
            LOGGER.error("{}: Class '{}' cannot be instantiated (abstract class): {}", implementedInterface.getSimpleName(), clazz.getName(), e.getLocalizedMessage());
            throw new ConfigurationException(e);
        }
        catch (IllegalAccessException | SecurityException e) {
            LOGGER.error("{}: Access to class '{}' denied: {}", implementedInterface.getSimpleName(), clazz.getName(), e.getLocalizedMessage());
            throw new ConfigurationException(e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("{}: Constructor signature of class '{}' does not match given parameters: {}", implementedInterface.getSimpleName(), clazz.getName(), e.getLocalizedMessage());
            throw new ConfigurationException(e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("{}: Constructor of class '{}' failed to initialite instance: {}", implementedInterface.getSimpleName(), clazz.getName(), e.getLocalizedMessage());
            throw new ConfigurationException(e);
        }
        catch (NoSuchMethodException e) {
            StringBuilder parameterTypeNames = new StringBuilder();
            for (Object parameter : parameters) {
                parameterTypeNames.append(", ");
                parameterTypeNames.append(parameter.getClass().getName());
            }
            LOGGER.error("{}: Class '{}' has to implement a (public) constructor that accepts the signature {}.", implementedInterface.getSimpleName(), clazz.getName(), parameterTypeNames.toString(), e);
            throw new ConfigurationException(e);
        }
    }
}

