/*
 * Decompiled with CFR 0.152.
 */
package kieker.extension.cassandra;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public final class CassandraUtils {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 9042;

    private CassandraUtils() {
    }

    public static List<InetSocketAddress> computeDatabaseConnections(String[] contactPointSpecs) {
        ArrayList<InetSocketAddress> contactPoints = new ArrayList<InetSocketAddress>();
        if (contactPointSpecs.length == 0) {
            InetSocketAddress socket = new InetSocketAddress(DEFAULT_HOST, 9042);
            contactPoints.add(socket);
        } else {
            for (String contactpoint : contactPointSpecs) {
                String[] array = contactpoint.split(":");
                if (array.length != 2) continue;
                InetSocketAddress socket = new InetSocketAddress(array[0], Integer.parseInt(array[1]));
                contactPoints.add(socket);
            }
        }
        return contactPoints;
    }
}

